/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.validation;

import org.eclipse.gmf.runtime.common.ui.util.UIModificationValidator;
import org.eclipse.stp.bpmn.validation.builder.BatchValidationBuildAbleNature;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The Bpmn Diagram Editor activator.
 */
public class BpmnValidationPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.stp.bpmn.validation";

    public static final String BATCH_VALIDATION_BUILD_ABLE_NATURE_ID =
        BatchValidationBuildAbleNature.NATURE_ID;
    
	// The shared instance
	private static BpmnValidationPlugin plugin;
	
	/**
	 * The constructor
	 */
	public BpmnValidationPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
        //this is a workaround for the stack trace documented below:
        new UIModificationValidator();//.dispose(); have to wait for 1.0.2
        //here is the stack trace when we notice the first validation via the builder takes a verylong time:
        /*
!ENTRY org.eclipse.osgi 4 0 2006-12-18 14:29:22.810
!MESSAGE While loading class "org.eclipse.gmf.runtime.common.ui.util.UIModificationValidator$WindowListener", thread "main" timed out waiting (5000ms) for thread "Worker-0" to finish starting bundle "org.eclipse.gmf.runtime.common.ui". To avoid deadlock, thread "main" is proceeding but "org.eclipse.gmf.runtime.common.ui.util.UIModificationValidator$WindowListener" may not be fully initialized.
!STACK 0
java.lang.Exception: Generated exception.
    at org.eclipse.core.runtime.internal.adaptor.EclipseLazyStarter.preFindLocalClass(EclipseLazyStarter.java:75)
    at org.eclipse.osgi.baseadaptor.loader.ClasspathManager.findLocalClass(ClasspathManager.java:409)
    at org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader.findLocalClass(DefaultClassLoader.java:188)
    at org.eclipse.osgi.framework.internal.core.BundleLoader.findLocalClass(BundleLoader.java:339)
    at org.eclipse.osgi.framework.internal.core.BundleLoader.findClass(BundleLoader.java:391)
    at org.eclipse.osgi.framework.internal.core.BundleLoader.findClass(BundleLoader.java:352)
    at org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader.loadClass(DefaultClassLoader.java:83)
    at java.lang.ClassLoader.loadClass(Unknown Source)
    at java.lang.ClassLoader.loadClassInternal(Unknown Source)
    at org.eclipse.gmf.runtime.common.ui.util.UIModificationValidator$1.run(UIModificationValidator.java:115)

	    */
    }

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static BpmnValidationPlugin getDefault() {
        return plugin;
	}
    
}
