/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.ArtifactsContainer;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnFactory;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.DirectionType;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Group;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.IdentifiableNode;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.NamedBpmnObject;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.impl.ActivityImpl;
import org.eclipse.stp.bpmn.impl.ArtifactImpl;
import org.eclipse.stp.bpmn.impl.ArtifactsContainerImpl;
import org.eclipse.stp.bpmn.impl.AssociationImpl;
import org.eclipse.stp.bpmn.impl.BpmnDiagramImpl;
import org.eclipse.stp.bpmn.impl.DataObjectImpl;
import org.eclipse.stp.bpmn.impl.GraphImpl;
import org.eclipse.stp.bpmn.impl.GroupImpl;
import org.eclipse.stp.bpmn.impl.IdentifiableImpl;
import org.eclipse.stp.bpmn.impl.IdentifiableNodeImpl;
import org.eclipse.stp.bpmn.impl.LaneImpl;
import org.eclipse.stp.bpmn.impl.MessagingEdgeImpl;
import org.eclipse.stp.bpmn.impl.NamedBpmnObjectImpl;
import org.eclipse.stp.bpmn.impl.PoolImpl;
import org.eclipse.stp.bpmn.impl.SequenceEdgeImpl;
import org.eclipse.stp.bpmn.impl.SubProcessImpl;
import org.eclipse.stp.bpmn.impl.TextAnnotationImpl;
import org.eclipse.stp.bpmn.impl.VertexImpl;

public class BpmnFactoryImpl
extends EFactoryImpl
implements BpmnFactory {
    public static final String copyright = "";

    public static BpmnFactory init() {
        try {
            BpmnFactory theBpmnFactory = (BpmnFactory)EPackage.Registry.INSTANCE.getEFactory("http://stp.eclipse.org/bpmn");
            if (theBpmnFactory != null) {
                return theBpmnFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new BpmnFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createActivity();
            }
            case 1: {
                return this.createArtifact();
            }
            case 2: {
                return this.createArtifactsContainer();
            }
            case 3: {
                return this.createAssociation();
            }
            case 4: {
                return this.createBpmnDiagram();
            }
            case 5: {
                return this.createDataObject();
            }
            case 6: {
                return this.createGraph();
            }
            case 7: {
                return this.createGroup();
            }
            case 8: {
                return this.createIdentifiable();
            }
            case 9: {
                return this.createIdentifiableNode();
            }
            case 10: {
                return this.createLane();
            }
            case 11: {
                return this.createMessagingEdge();
            }
            case 12: {
                return this.createNamedBpmnObject();
            }
            case 13: {
                return this.createPool();
            }
            case 14: {
                return this.createSequenceEdge();
            }
            case 15: {
                return this.createSubProcess();
            }
            case 16: {
                return this.createTextAnnotation();
            }
            case 17: {
                return this.createVertex();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 18: {
                return this.createActivityTypeFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createDirectionTypeFromString(eDataType, initialValue);
            }
            case 20: {
                return this.createActivityTypeObjectFromString(eDataType, initialValue);
            }
            case 21: {
                return this.createDirectionTypeObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 18: {
                return this.convertActivityTypeToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertDirectionTypeToString(eDataType, instanceValue);
            }
            case 20: {
                return this.convertActivityTypeObjectToString(eDataType, instanceValue);
            }
            case 21: {
                return this.convertDirectionTypeObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Activity createActivity() {
        ActivityImpl activity = new ActivityImpl();
        activity.iD = EcoreUtil.generateUUID();
        return activity;
    }

    public Artifact createArtifact() {
        ArtifactImpl artifact = new ArtifactImpl();
        return artifact;
    }

    public ArtifactsContainer createArtifactsContainer() {
        ArtifactsContainerImpl artifactsContainer = new ArtifactsContainerImpl();
        return artifactsContainer;
    }

    public Association createAssociation() {
        AssociationImpl association = new AssociationImpl();
        return association;
    }

    public BpmnDiagram createBpmnDiagram() {
        BpmnDiagramImpl bpmnDiagram = new BpmnDiagramImpl();
        bpmnDiagram.iD = EcoreUtil.generateUUID();
        return bpmnDiagram;
    }

    public DataObject createDataObject() {
        DataObjectImpl dataObject = new DataObjectImpl();
        return dataObject;
    }

    public Graph createGraph() {
        GraphImpl graph = new GraphImpl();
        return graph;
    }

    public Group createGroup() {
        GroupImpl group = new GroupImpl();
        return group;
    }

    public Identifiable createIdentifiable() {
        IdentifiableImpl identifiable = new IdentifiableImpl();
        return identifiable;
    }

    public IdentifiableNode createIdentifiableNode() {
        IdentifiableNodeImpl identifiableNode = new IdentifiableNodeImpl();
        return identifiableNode;
    }

    public Lane createLane() {
        LaneImpl lane = new LaneImpl();
        lane.iD = EcoreUtil.generateUUID();
        return lane;
    }

    public MessagingEdge createMessagingEdge() {
        MessagingEdgeImpl messagingEdge = new MessagingEdgeImpl();
        messagingEdge.iD = EcoreUtil.generateUUID();
        return messagingEdge;
    }

    public NamedBpmnObject createNamedBpmnObject() {
        NamedBpmnObjectImpl namedBpmnObject = new NamedBpmnObjectImpl();
        return namedBpmnObject;
    }

    public Pool createPool() {
        PoolImpl pool = new PoolImpl();
        pool.setID(EcoreUtil.generateUUID());
        return pool;
    }

    public SequenceEdge createSequenceEdge() {
        SequenceEdgeImpl edge = new SequenceEdgeImpl();
        edge.iD = EcoreUtil.generateUUID();
        return edge;
    }

    public SubProcess createSubProcess() {
        SubProcessImpl subProcess = new SubProcessImpl();
        subProcess.iD = EcoreUtil.generateUUID();
        return subProcess;
    }

    public TextAnnotation createTextAnnotation() {
        TextAnnotationImpl textAnnotation = new TextAnnotationImpl();
        return textAnnotation;
    }

    public Vertex createVertex() {
        VertexImpl vertex = new VertexImpl();
        vertex.iD = EcoreUtil.generateUUID();
        return vertex;
    }

    public ActivityType createActivityTypeFromString(EDataType eDataType, String initialValue) {
        ActivityType result = ActivityType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertActivityTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DirectionType createDirectionTypeFromString(EDataType eDataType, String initialValue) {
        DirectionType result = DirectionType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDirectionTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ActivityType createActivityTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createActivityTypeFromString((EDataType)BpmnPackage.Literals.ACTIVITY_TYPE, initialValue);
    }

    public String convertActivityTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertActivityTypeToString((EDataType)BpmnPackage.Literals.ACTIVITY_TYPE, instanceValue);
    }

    public DirectionType createDirectionTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createDirectionTypeFromString((EDataType)BpmnPackage.Literals.DIRECTION_TYPE, initialValue);
    }

    public String convertDirectionTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertDirectionTypeToString((EDataType)BpmnPackage.Literals.DIRECTION_TYPE, instanceValue);
    }

    public BpmnPackage getBpmnPackage() {
        return (BpmnPackage)this.getEPackage();
    }

    public static BpmnPackage getPackage() {
        return BpmnPackage.eINSTANCE;
    }
}

