/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.stp.common.logging.LoggingProxy;

public class FileUtils {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(FileUtils.class);

    public static String getFileName(String path) {
        if (path.lastIndexOf("/") >= 0) {
            return path.substring(path.lastIndexOf("/") + 1, path.length());
        }
        if (path.lastIndexOf("\\") >= 0) {
            return path.substring(path.lastIndexOf("\\") + 1, path.length());
        }
        return path;
    }

    public static boolean copyFile(InputStream is, String targetFileName) {
        FileOutputStream fos;
        block19: {
            fos = null;
            File targetFile = new File(targetFileName);
            targetFile.createNewFile();
            fos = new FileOutputStream(targetFile);
            int len = 1024;
            byte[] bytes = new byte[len];
            int count = 0;
            while ((count = is.read(bytes)) > 0) {
                fos.write(bytes, 0, count);
            }
            bytes = null;
            if (fos == null) break block19;
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        try {
            return true;
        }
        catch (Exception e) {
            block20: {
                try {
                    LOG.error("error during copy file to:" + targetFileName, e);
                    if (fos == null) break block20;
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            try {
                is.close();
            }
            catch (Exception exception) {}
            return false;
        }
    }

    public static String copyFile(String originalFile, String path) {
        String string;
        AbstractInterruptibleChannel wbc;
        AbstractInterruptibleChannel rbc;
        block23: {
            rbc = null;
            wbc = null;
            File oriFile = new File(originalFile);
            File targetFile = new File(path, oriFile.getName());
            targetFile.createNewFile();
            ByteBuffer bb = ByteBuffer.allocate(8192);
            rbc = new FileInputStream(oriFile).getChannel();
            wbc = new FileOutputStream(targetFile).getChannel();
            while (((FileChannel)rbc).read(bb) > 0) {
                bb.flip();
                ((FileChannel)wbc).write(bb);
                bb.clear();
            }
            string = String.valueOf(path) + File.separator + oriFile.getName();
            if (rbc == null) break block23;
            try {
                rbc.close();
            }
            catch (IOException iOException) {}
        }
        if (wbc != null) {
            try {
                wbc.close();
            }
            catch (IOException iOException) {}
        }
        try {
            return string;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                if (rbc != null) {
                    try {
                        rbc.close();
                    }
                    catch (IOException iOException) {}
                }
                if (wbc != null) {
                    try {
                        wbc.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
        if (rbc != null) {
            try {
                rbc.close();
            }
            catch (IOException iOException) {}
        }
        if (wbc != null) {
            try {
                wbc.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

