/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.utils;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ResourceUtils {
    protected ResourceUtils() {
    }

    public static IProject getActiveProject() {
        IResource selResource = ResourceUtils.getSelectedResource();
        if (selResource != null) {
            return selResource.getProject();
        }
        return null;
    }

    public static IResource getSelectedResource() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IResource selResource = ResourceUtils.getSelectedResource(page);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page) {
        IResource selResource = null;
        ISelection sel = page.getSelection();
        selResource = ResourceUtils.getSelectedResource(page, sel);
        return selResource;
    }

    public static IResource getSelectedResource(IWorkbenchPage page, ISelection sel) {
        IResource selResource = null;
        if (sel instanceof StructuredSelection) {
            IEditorPart activeEditor;
            IAdaptable adaptable;
            StructuredSelection ssel = (StructuredSelection)sel;
            Object element = ssel.getFirstElement();
            if (element instanceof IResource) {
                selResource = (IResource)element;
            } else if (element instanceof IAdaptable && (selResource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) == null && (activeEditor = page.getActiveEditor()) != null) {
                selResource = (IResource)activeEditor.getAdapter(IResource.class);
            }
        } else if (sel instanceof TextSelection) {
            IEditorPart editor = page.getActiveEditor();
            if (editor == null) {
                return null;
            }
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                selResource = ((IFileEditorInput)input).getFile();
            }
        }
        return selResource;
    }

    public static String getFileNameWithoutExt(IPath filePath) {
        String path = filePath.toOSString();
        String fileName = path.substring(path.lastIndexOf(File.separator) + 1, path.length());
        int idx = fileName.indexOf(".");
        if (idx >= 0) {
            return fileName.substring(0, idx);
        }
        return fileName;
    }
}

