/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.utils;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class UIUtils {
    private UIUtils() {
    }

    public static void selectWidget(Widget widget) {
        UIUtils.selectWidget(widget, true);
    }

    public static void selectWidget(Widget widget, int index) {
        Event event = new Event();
        event.widget = widget;
        if (widget instanceof Combo) {
            if (index < -1) {
                index = -1;
            }
            if (index == -1) {
                ((Combo)widget).deselectAll();
            }
            ((Combo)widget).select(index);
        }
        if (widget instanceof Table) {
            if (index == -1) {
                ((Table)widget).deselectAll();
            }
            ((Table)widget).select(index);
        }
        if (widget instanceof List) {
            if (index == -1) {
                ((List)widget).deselectAll();
            }
            ((List)widget).select(index);
        }
        if (widget instanceof Tree) {
            if (index == -1) {
                ((Tree)widget).deselectAll();
            }
            ((Tree)widget).setSelection(new TreeItem[]{((Tree)widget).getItem(index)});
        }
        widget.notifyListeners(13, event);
    }

    public static void selectWidget(Widget widget, boolean selected) {
        Event event = new Event();
        event.widget = widget;
        if (widget instanceof Button) {
            Button button = (Button)widget;
            if (selected && (button.getStyle() & 0x10) != 0) {
                Control[] children = button.getParent().getChildren();
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    if (widget != child && child instanceof Button) {
                        ((Button)child).setSelection(false);
                    }
                    ++i;
                }
            }
            ((Button)widget).setSelection(selected);
        }
        widget.notifyListeners(13, event);
    }

    public static String[] getStringsFromCommaSeparatedList(String commaSeparatedList) {
        String[] items = commaSeparatedList.split(",");
        return items;
    }

    public static String getNonNullValue(String value) {
        return value == null ? "" : value;
    }

    public static int getSelectedIndex(String selection, String[] choices) {
        int i = 0;
        while (i < choices.length) {
            if (selection.equals(choices[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static void computeTableWidth(TableViewer tv) {
        UIUtils.computeTableWidth(tv.getTable());
    }

    public static void computeTableWidth(Table table) {
        int columnsAmount = table.getColumnCount();
        int i = 0;
        while (i < columnsAmount) {
            table.getColumn(i).setWidth(table.getClientArea().width / columnsAmount);
            ++i;
        }
    }
}

