/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.infrastructure.validateedit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;
import org.eclipse.stp.core.infrastructure.validateedit.ResourceStateInputProvider;
import org.eclipse.stp.core.infrastructure.validateedit.ResourceStateValidator;
import org.eclipse.stp.core.infrastructure.validateedit.ResourceStateValidatorPresenter;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;

public class ResourceStateValidatorImpl
implements ResourceStateValidator {
    protected ResourceStateInputProvider provider;
    protected Map lastNonRefreshStateMap;
    protected boolean isCheckingConsistency;

    public ResourceStateValidatorImpl(ResourceStateInputProvider aProvider) {
        this.provider = aProvider;
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.checkConsistency(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.checkConsistency(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return false;
        }
        if (!this.provider.isDirty()) {
            return false;
        }
        List inconsistentResources = this.getInconsistentResources();
        List inconsistentFiles = this.getFiles(inconsistentResources);
        if ((inconsistentFiles = this.addOtherInconsistentFiles(inconsistentFiles)) == null || inconsistentFiles.isEmpty()) {
            return true;
        }
        return presenter.promptForInconsistentFileOverwrite(inconsistentFiles);
    }

    public boolean checkReadOnly() {
        boolean result = this.checkReadOnlyResources();
        if (!result) {
            result = this.checkReadOnlyNonResourceFiles();
        }
        return result;
    }

    private boolean checkReadOnlyNonResourceFiles() {
        List files = this.provider.getNonResourceFiles();
        if (files == null || files.isEmpty()) {
            return false;
        }
        int size = files.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isReadOnly()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkReadOnlyResources() {
        List resources = this.provider.getResources();
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        int size = resources.size();
        Resource res = null;
        IFile file = null;
        int i = 0;
        while (i < size) {
            res = (Resource)resources.get(i);
            file = WorkbenchResourceHelper.getFile(res);
            if (file != null && file.isReadOnly()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void checkConsistency(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (this.isCheckingConsistency || presenter == null) {
            return;
        }
        this.isCheckingConsistency = true;
        try {
            List inconsistentResources = this.getInconsistentResources();
            List inconsistentFiles = this.getFiles(inconsistentResources);
            inconsistentFiles = this.addOtherInconsistentFiles(inconsistentFiles);
            if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
                return;
            }
            boolean shouldRefreshFiles = true;
            if (!this.anyFileChangedSinceLastRefreshPrompt(inconsistentFiles)) {
                return;
            }
            this.clearLastNonRefreshStateMap();
            shouldRefreshFiles = presenter.promptForInconsistentFileRefresh(inconsistentFiles);
            if (shouldRefreshFiles) {
                this.refreshFiles(inconsistentFiles, inconsistentResources);
            } else {
                this.cacheLastNonRefreshFileStamps(inconsistentFiles);
            }
        }
        finally {
            this.isCheckingConsistency = false;
        }
    }

    private void cacheLastNonRefreshFileStamps(List inconsistentFiles) {
        if (inconsistentFiles != null && !inconsistentFiles.isEmpty()) {
            Map map = this.getLastNonRefreshStateMap();
            IFile file = null;
            long stamp = 0L;
            int i = 0;
            while (i < inconsistentFiles.size()) {
                file = (IFile)inconsistentFiles.get(i);
                stamp = WorkbenchResourceHelper.computeModificationStamp(file);
                map.put(file, new Long(stamp));
                ++i;
            }
        }
    }

    private void cacheValidateState(IStatus aStatus, List readOnlyResources, List roNonResourceFiles) {
        if (aStatus.isOK()) {
            if (readOnlyResources != null && !readOnlyResources.isEmpty()) {
                ReferencedResource res = null;
                int i = 0;
                while (i < readOnlyResources.size()) {
                    res = (ReferencedResource)readOnlyResources.get(i);
                    WorkbenchResourceHelper.setSynhronizationStamp(res, this.computeModificationStamp(res));
                    ++i;
                }
            }
            this.provider.cacheNonResourceValidateState(roNonResourceFiles);
        }
    }

    private void clearLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap != null) {
            this.lastNonRefreshStateMap.clear();
        }
    }

    private boolean anyFileChangedSinceLastRefreshPrompt(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
            return false;
        }
        if (this.lastNonRefreshStateMap == null || this.lastNonRefreshStateMap.isEmpty()) {
            return true;
        }
        int size = inconsistentFiles.size();
        IFile file = null;
        Long stamp = null;
        int i = 0;
        while (i < size) {
            file = (IFile)inconsistentFiles.get(i);
            stamp = (Long)this.getLastNonRefreshStateMap().get(file);
            if (stamp == null || stamp != WorkbenchResourceHelper.computeModificationStamp(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List addOtherInconsistentFiles(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
            return this.getNonResourceInconsistentFiles();
        }
        List nonResFiles = this.getNonResourceInconsistentFiles();
        if (nonResFiles != null) {
            inconsistentFiles.addAll(nonResFiles);
        }
        return inconsistentFiles;
    }

    private List getNonResourceInconsistentFiles() {
        List files = this.provider.getNonResourceInconsistentFiles();
        if (files != null && !files.isEmpty()) {
            return files;
        }
        files = this.provider.getNonResourceFiles();
        if (files == null || files.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFile> inconsistent = null;
        int size = files.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isAccessible() && !file.isSynchronized(0)) {
                if (inconsistent == null) {
                    inconsistent = new ArrayList<IFile>();
                }
                inconsistent.add(file);
            }
            ++i;
        }
        if (inconsistent == null) {
            inconsistent = Collections.EMPTY_LIST;
        }
        return inconsistent;
    }

    protected List getInconsistentResources() {
        List mofResources = this.provider.getResources();
        ArrayList<ReferencedResource> inconsistent = null;
        int size = mofResources.size();
        Resource res = null;
        ReferencedResource refRes = null;
        int i = 0;
        while (i < size) {
            res = (Resource)mofResources.get(i);
            if (WorkbenchResourceHelper.isReferencedResource(res) && !WorkbenchResourceHelper.isConsistent(refRes = (ReferencedResource)res)) {
                if (inconsistent == null) {
                    inconsistent = new ArrayList<ReferencedResource>();
                }
                inconsistent.add(refRes);
            }
            ++i;
        }
        if (inconsistent == null) {
            inconsistent = Collections.EMPTY_LIST;
        }
        return inconsistent;
    }

    protected List getFiles(List refResources) {
        ArrayList<IFile> files = new ArrayList<IFile>(refResources.size());
        IFile file = null;
        ReferencedResource refRes = null;
        int i = 0;
        while (i < refResources.size()) {
            refRes = (ReferencedResource)refResources.get(i);
            file = WorkbenchResourceHelper.getFile(refRes);
            if (file != null) {
                files.add(file);
            }
            ++i;
        }
        return files;
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        List roFiles = null;
        List[] readOnly = this.selectReadOnlyResources(this.provider.getResources());
        List roResources = readOnly[0];
        roFiles = readOnly[1];
        List nonResROFiles = this.selectReadOnlyFiles(this.provider.getNonResourceFiles());
        if (nonResROFiles != null) {
            if (roFiles == null) {
                roFiles = nonResROFiles;
            } else {
                roFiles.addAll(nonResROFiles);
            }
        }
        if (roFiles == null || roFiles.isEmpty()) {
            return OK_STATUS;
        }
        IFile[] files = new IFile[roFiles.size()];
        roFiles.toArray(files);
        Object ctx = presenter != null ? presenter.getValidateEditContext() : null;
        IStatus result = ResourcesPlugin.getWorkspace().validateEdit(files, ctx);
        this.cacheValidateState(result, roResources, nonResROFiles);
        if (!result.isOK()) {
            this.checkConsistency(presenter);
        }
        return result;
    }

    private List selectReadOnlyFiles(List files) {
        if (files == null || files.isEmpty()) {
            return files;
        }
        int size = files.size();
        ArrayList<IFile> readOnly = null;
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isReadOnly()) {
                if (readOnly == null) {
                    readOnly = new ArrayList<IFile>(size);
                }
                readOnly.add(file);
            }
            ++i;
        }
        return readOnly;
    }

    private List[] selectReadOnlyResources(List resources) {
        if (resources == null || resources.isEmpty()) {
            List[] listArray = new List[2];
            listArray[0] = resources;
            return listArray;
        }
        IFile file = null;
        int size = resources.size();
        Resource res = null;
        ArrayList<Resource> readOnly = null;
        ArrayList<IFile> roFiles = null;
        int i = 0;
        while (i < size) {
            res = (Resource)resources.get(i);
            file = WorkbenchResourceHelper.getFile(res);
            if (file != null && file.isReadOnly()) {
                if (readOnly == null) {
                    readOnly = new ArrayList<Resource>(size);
                }
                readOnly.add(res);
                if (roFiles == null) {
                    roFiles = new ArrayList<IFile>(size);
                }
                roFiles.add(file);
            }
            ++i;
        }
        return new List[]{readOnly, roFiles};
    }

    protected long computeModificationStamp(ReferencedResource resource) {
        return WorkbenchResourceHelper.computeModificationStamp(resource);
    }

    protected void refreshFiles(List someFiles, List inconsitentResources) throws CoreException {
        RefreshRunnable runnable = new RefreshRunnable(someFiles, inconsitentResources);
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, null);
        if (runnable.getThrownException() != null) {
            throw runnable.getThrownException();
        }
    }

    protected void primRefreshFiles(List someFiles) throws CoreException {
        int size = someFiles.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)someFiles.get(i);
            if (!file.isSynchronized(0)) {
                file.refreshLocal(1, null);
            } else {
                this.refreshResource(file);
            }
            ++i;
        }
    }

    protected void refreshResource(IFile file) {
        Resource res = WorkbenchResourceHelperBase.getResource((IFile)file);
        if (res != null) {
            res.unload();
        }
    }

    protected void prepareResourcesForRefresh(List refResources) {
        ReferencedResource res = null;
        int i = 0;
        while (i < refResources.size()) {
            res = (ReferencedResource)refResources.get(i);
            res.setForceRefresh(true);
            ++i;
        }
    }

    protected Map getLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap == null) {
            this.lastNonRefreshStateMap = new HashMap();
        }
        return this.lastNonRefreshStateMap;
    }

    class RefreshRunnable
    implements IWorkspaceRunnable {
        CoreException thrownException;
        List files;
        List resources;

        RefreshRunnable(List someFiles, List inconsistentResources) {
            this.files = someFiles;
            this.resources = inconsistentResources;
        }

        public CoreException getThrownException() {
            return this.thrownException;
        }

        public void run(IProgressMonitor aMonitor) {
            try {
                ResourceStateValidatorImpl.this.prepareResourcesForRefresh(this.resources);
                ResourceStateValidatorImpl.this.primRefreshFiles(this.files);
            }
            catch (CoreException e) {
                this.thrownException = e;
            }
        }
    }
}

