/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EditModelDisposedException;
import org.eclipse.stp.core.infrastructure.emf.EditModelEvent;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IEditModelListener;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IHumanInteractionController;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.ITechnologyFlavor;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;
import org.eclipse.stp.core.infrastructure.validateedit.ResourceStateInputProvider;
import org.eclipse.stp.core.internal.infrastructure.emf.DeletedResourceAdapter;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.EditModel;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;
import org.eclipse.stp.core.internal.infrastructure.emf.ReadOnlyAdapter;
import org.eclipse.stp.core.internal.infrastructure.emf.ScribblerAdapter;
import org.eclipse.stp.core.internal.infrastructure.emf.ScribblerEMFCommandStack;
import org.eclipse.stp.core.internal.infrastructure.emf.UnreleasedScribblerException;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class EditModelScribbler
implements IEditModelScribbler,
CommandStackListener,
ResourceStateInputProvider {
    private static final IScribblerDomain[] NO_DOMAINS = new IScribblerDomain[0];
    private static final Class EMF_COMMAND_STACK_CLASS = CommandStack.class;
    private static final Class IEDITMODELSCRIBBLER_CLASS = IEditModelScribbler.class;
    private final Set scribblerDomains;
    private IHumanInteractionController userInterfaceController;
    private ScribblerEMFCommandStack emfCmdStck;
    private final ScribblerResourceManager internalState;

    EditModelScribbler(EditModel anEditModel, IScribblerDomain[] theDomains, boolean toMakeReadOnly) {
        this.internalState = new ScribblerResourceManager(this, anEditModel, toMakeReadOnly);
        this.scribblerDomains = theDomains == null || theDomains.length == 0 ? Collections.EMPTY_SET : new HashSet<IScribblerDomain>(Arrays.asList(theDomains));
        this.init();
    }

    private void init() {
        block3: for (IScribblerDomain scribbler : this.scribblerDomains) {
            IResourceDescriptor[] descriptors = scribbler.getResourceDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                IPath localPath = descriptors[i].getLocalPath();
                try {
                    Resource resource = this.internalState.editModel.getResource(URI.createPlatformResourceURI((String)localPath.toString()), true, false);
                    if (resource != null) {
                        if (descriptors[i].isLoadAsReadOnly()) {
                            this.markResourceAsReadOnly(resource);
                        }
                        this.internalState.manageResource(resource, true);
                    }
                }
                catch (EditModelDisposedException emde) {
                    EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, emde.getLocalizedMessage(), emde));
                    continue block3;
                }
                catch (EditModelException eme) {
                    EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, eme.getLocalizedMessage(), eme));
                }
                ++i;
            }
        }
    }

    public Resource getResource(IPath aWorkspaceRelativePath) {
        return this.getResource(URI.createPlatformResourceURI((String)aWorkspaceRelativePath.toString()), true);
    }

    public Resource getResource(IPath aWorkspaceRelativePath, int options) {
        Resource resource = this.getResource(URI.createPlatformResourceURI((String)aWorkspaceRelativePath.toString()), (options & 2) != 0);
        if ((options & 4) != 0) {
            this.markResourceAsReadOnly(resource);
        }
        return resource;
    }

    public Resource getResource(IResourceDescriptor aDescriptor) {
        Resource resource = this.getResource(aDescriptor, 2);
        if (aDescriptor.isLoadAsReadOnly()) {
            this.markResourceAsReadOnly(resource);
        }
        return resource;
    }

    public Resource getResource(IResourceDescriptor aDescriptor, int options) {
        String workspaceRelativePath = aDescriptor.getLocalPath().toString();
        URI descriptorURI = URI.createURI((String)(String.valueOf(aDescriptor.getRequestProtocol()) + workspaceRelativePath));
        Resource resource = this.getResource(descriptorURI, (options & 2) != 0);
        if ((options & 4) != 0 || aDescriptor.isLoadAsReadOnly()) {
            this.markResourceAsReadOnly(resource);
        }
        return resource;
    }

    public Resource getResource(URI aUri) {
        return this.getResource(aUri, true);
    }

    public Resource getResource(URI aUri, int options) {
        Resource resource = this.getResource(aUri, (options & 2) != 0);
        if ((options & 4) != 0) {
            this.markResourceAsReadOnly(resource);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResource(URI aUri, boolean loadOnDemand) {
        this.complainIfDisposed();
        Resource foundResource = null;
        EditModelScribbler editModelScribbler = this;
        synchronized (editModelScribbler) {
            if (aUri == null || aUri.segmentCount() == 0) {
                return null;
            }
            try {
                Resource resource = null;
                Iterator resourcesItr = this.internalState.resources.iterator();
                while (resourcesItr.hasNext() && foundResource == null) {
                    resource = (Resource)resourcesItr.next();
                    if (!ExtendedEcoreUtil.endsWith((URI)resource.getURI(), (URI)aUri)) continue;
                    foundResource = resource;
                }
                if (foundResource != null) {
                    if (loadOnDemand && !foundResource.isLoaded()) {
                        try {
                            foundResource.load(null);
                        }
                        catch (IOException e) {
                            this.internalState.editModel.getErrorHandler().handleLoadFailed(aUri, (Exception)e);
                        }
                    }
                    return foundResource;
                }
                try {
                    foundResource = this.internalState.editModel.getResource(aUri, false, loadOnDemand);
                }
                catch (EditModelException e) {
                    EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e));
                }
                if (foundResource != null) {
                    this.internalState.manageResource(foundResource, false);
                }
            }
            catch (RuntimeException e) {
                this.internalState.editModel.getErrorHandler().handleLoadFailed(aUri, (Exception)e);
            }
        }
        return foundResource;
    }

    private void markResourceAsReadOnly(Resource resource) {
        if (!this.isReadOnly(resource)) {
            resource.eAdapters().add((Object)this.internalState.readOnlyAdapter);
        }
    }

    private void complainIfDisposed() {
        if (this.internalState.isVaporized) {
            throw new IllegalStateException(Messages.The_IEditModelScribbler_);
        }
    }

    public Resource createResource(IResourceDescriptor aResourceDescriptor, IProgressMonitor monitor) {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    public boolean deleteResource(IResourceDescriptor aResourceDescriptor, IProgressMonitor monitor) throws EditModelException {
        Resource resource = this.getResource(aResourceDescriptor, 0);
        return this.deleteResource(resource, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteResource(Resource aResource, IProgressMonitor monitor) throws EditModelException {
        if (this.isReadOnly(aResource)) {
            throw new EditModelException(NLS.bind((String)Messages.Attempt_to_delete_a_readonly_resource, (Object)aResource));
        }
        boolean result = false;
        EditModelScribbler editModelScribbler = this;
        synchronized (editModelScribbler) {
            monitor.beginTask(NLS.bind((String)Messages.Deleting_resource_0, (Object)aResource.getURI()), 1);
            try {
                result = this.internalState.delete(aResource, monitor);
            }
            catch (CoreException e) {
                throw new EditModelException(e.getMessage());
            }
            monitor.worked(1);
            monitor.subTask(Messages.Finished_deleting_resour_);
            monitor.done();
        }
        return result;
    }

    private boolean isReadOnly(Resource resource) {
        return this.internalState.isReadOnly(resource);
    }

    public Resource[] getSortedResources() {
        return this.internalState.getResources().toArray(new Resource[this.internalState.getResources().size()]);
    }

    public String getLabel() {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    public boolean matches(IUndoContext context) {
        if (context instanceof EditModelScribbler) {
            EditModelScribbler otherScribbler = (EditModelScribbler)context;
            if (otherScribbler.internalState.editModel == this.internalState.editModel) {
                IScribblerDomain[] otherDomains = EditModelScribbler.createDomainArray((IEditModelScribbler)context);
                IScribblerDomain[] myDomains = EditModelScribbler.createDomainArray(this);
                boolean matchedOne = false;
                int myDomainsIndx = 0;
                while (myDomainsIndx < myDomains.length) {
                    int otherDomainsIndx = 0;
                    while (otherDomainsIndx < otherDomains.length && !matchedOne) {
                        if (myDomains[myDomainsIndx].matches(otherDomains[otherDomainsIndx])) {
                            matchedOne = true;
                        }
                        ++otherDomainsIndx;
                    }
                    if (!matchedOne) {
                        return false;
                    }
                    matchedOne = false;
                    ++myDomainsIndx;
                }
                return true;
            }
        }
        return false;
    }

    private static IScribblerDomain[] createDomainArray(IEditModelScribbler scribbler) {
        if (scribbler == null || scribbler.getScribblerDomains().size() == 0) {
            return NO_DOMAINS;
        }
        Set domains = scribbler.getScribblerDomains();
        return domains.toArray(new IScribblerDomain[domains.size()]);
    }

    public void commandStackChanged(EventObject event) {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(IProgressMonitor monitor) throws EditModelException {
        this.complainIfDisposed();
        EditModelScribbler editModelScribbler = this;
        synchronized (editModelScribbler) {
            if (!this.internalState.isReadOnly && this.isDirty()) {
                IStatus directionStatus = EMFInfrastructurePlugin.createStatus(1, 0, Messages.Would_you_like_to_save_y_, null);
                if (this.getUserInterfaceController() != null) {
                    IHumanInteractionController.Response response = this.getUserInterfaceController().requestDirection(directionStatus);
                    if (response.shouldProceed() != null && response.shouldProceed().booleanValue()) {
                        try {
                            this.save(true, monitor);
                        }
                        finally {
                            this.disconnect();
                        }
                    } else {
                        this.discard(monitor);
                    }
                } else {
                    try {
                        this.save(false, monitor);
                    }
                    finally {
                        this.disconnect();
                    }
                }
            } else {
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(IProgressMonitor monitor) throws EditModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        EditModelScribbler editModelScribbler = this;
        synchronized (editModelScribbler) {
            try {
                try {
                    monitor.beginTask(Messages.Discarding_changes_to_resources, this.internalState.resources.size() + 2);
                    monitor.worked(1);
                    this.internalState.revert(monitor);
                }
                catch (CoreException e) {
                    EMFInfrastructurePlugin.logError(0, e.getMessage(), e);
                    throw new EditModelException(e.getMessage());
                }
            }
            finally {
                monitor.subTask(Messages.Disconnecting_from_the_u_);
                this.disconnect();
                monitor.worked(1);
                monitor.subTask(Messages.Completed_discarding_cha_);
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(boolean force, IProgressMonitor monitor) throws EditModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        EditModelScribbler editModelScribbler = this;
        synchronized (editModelScribbler) {
            if (this.internalState.isReadOnly || this.internalState.isVaporized) {
                throw new EditModelException(Messages.Cannot_save_resources_lo_);
            }
            if (force || !this.internalState.editModel.isShared(this)) {
                Resource[] resourcesToSave = this.internalState.partitionResources().modifiedResources;
                this.internalState.editModel.handleSave(resourcesToSave, monitor);
                this.internalState.deletedResources.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert(IProgressMonitor monitor) throws EditModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        EditModelScribbler editModelScribbler = this;
        synchronized (editModelScribbler) {
            try {
                this.internalState.revert(monitor);
            }
            catch (CoreException e) {
                EMFInfrastructurePlugin.logError(0, e.getMessage(), e);
                throw new EditModelException(e.getMessage());
            }
        }
    }

    public void setUserInterfaceController(IHumanInteractionController aUserInterfaceController) {
        this.userInterfaceController = aUserInterfaceController;
    }

    public IHumanInteractionController getUserInterfaceController() {
        return this.userInterfaceController;
    }

    public IStatus execute(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable args) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.Executing_operation, 10);
        IStatus status = null;
        try {
            operation.addContext((IUndoContext)this);
            status = this.internalState.editModel.getOperationHistory().execute(operation, monitor, args);
        }
        catch (EditModelException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
            EMFInfrastructurePlugin.log(status);
        }
        catch (ExecutionException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
        }
        return status;
    }

    public IStatus undo(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable args) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus status = null;
        try {
            status = this.internalState.editModel.getOperationHistory().undoOperation(operation, monitor, args);
        }
        catch (EditModelException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
            EMFInfrastructurePlugin.log(status);
        }
        catch (ExecutionException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
        }
        return status;
    }

    public IStatus redo(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable args) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus status = null;
        try {
            status = this.internalState.editModel.getOperationHistory().redoOperation(operation, monitor, args);
        }
        catch (EditModelException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
            EMFInfrastructurePlugin.log(status);
        }
        catch (ExecutionException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
        }
        return status;
    }

    public IStatus undoLast(IProgressMonitor monitor, IAdaptable args) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus status = null;
        try {
            status = this.internalState.editModel.getOperationHistory().undo((IUndoContext)this, monitor, args);
        }
        catch (EditModelException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
            EMFInfrastructurePlugin.log(status);
        }
        catch (ExecutionException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
        }
        return status;
    }

    public IStatus redoLast(IProgressMonitor monitor, IAdaptable args) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IStatus status = null;
        try {
            status = this.internalState.editModel.getOperationHistory().redo((IUndoContext)this, monitor, args);
        }
        catch (EditModelException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
            EMFInfrastructurePlugin.log(status);
        }
        catch (ExecutionException e) {
            status = EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e);
        }
        return status;
    }

    public void flushOperationHistory(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask(Messages.Flushing_the_operation_h_, 2);
        }
        try {
            this.internalState.editModel.getOperationHistory().dispose((IUndoContext)this, true, true, false);
        }
        catch (EditModelException e) {
            EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e));
        }
        if (monitor != null) {
            monitor.beginTask(Messages.Completed_flushing_the_o_, 2);
        }
    }

    public boolean isDirty() {
        return this.internalState.isDirty();
    }

    public boolean isReadOnly() {
        return this.internalState.isReadOnly;
    }

    public List getResources() {
        return Collections.unmodifiableList(new ArrayList(this.internalState.getResources()));
    }

    public List getNonResourceFiles() {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    public List getNonResourceInconsistentFiles() {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    public void cacheNonResourceValidateState(List roNonResourceFiles) {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    public ITechnologyFlavor createTechnologyFlavor(String technologyFlavorLifecycleId) {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    public ITechnologyFlavor createTechnologyFlavor(String technologyFlavorLifecycleId, IAdaptable input) {
        throw new UnsupportedOperationException(Messages.Method_not_yet_implement_);
    }

    public Set getScribblerDomains() {
        return Collections.unmodifiableSet(this.scribblerDomains);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EMF_COMMAND_STACK_CLASS) {
            if (this.emfCmdStck == null) {
                this.emfCmdStck = new ScribblerEMFCommandStack(this);
            }
            return this.emfCmdStck;
        }
        if (adapter == IEDITMODELSCRIBBLER_CLASS) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IUndoContext getUndoContext() {
        return this;
    }

    private void disconnect() {
        this.internalState.vaporize();
    }

    private static class ScribblerResourceManager
    implements IEditModelListener {
        protected final ReadOnlyAdapter readOnlyAdapter = new ReadOnlyAdapter();
        protected final DeletedResourceAdapter deletedResourceAdapter = new DeletedResourceAdapter();
        private WeakReference scribblerReference;
        protected final boolean isReadOnly;
        private final EditModel editModel;
        protected final Set resources = new HashSet();
        protected final Set deletedResources = new HashSet();
        private boolean isVaporized = false;

        ScribblerResourceManager(EditModelScribbler aScribbler, EditModel theEditModel, boolean toMakeReadOnly) {
            this.scribblerReference = new WeakReference<EditModelScribbler>(aScribbler);
            this.isReadOnly = toMakeReadOnly;
            this.editModel = theEditModel;
            try {
                this.editModel.addListener(this);
            }
            catch (EditModelException e) {
                EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, e.getLocalizedMessage(), e));
            }
        }

        public void editModelChanged(IEditModel notifyingEditModel, EditModelEvent anEvent) {
            Assert.isTrue(notifyingEditModel == this.editModel);
            EditModelScribbler scribbler = this.getEnclosingScribbler();
            if (scribbler == null) {
                EMFInfrastructurePlugin.logError(0, Messages.A_scribbler_has_not_been_, null);
                UnreleasedScribblerException[] exceptions = this.editModel.computeUnreleasedScribblers();
                int i = 0;
                while (i < exceptions.length) {
                    EMFInfrastructurePlugin.logError(0, Messages.The_following_exception_, exceptions[i]);
                    ++i;
                }
                this.vaporize();
            } else {
                switch (anEvent.getEventCode()) {
                    case 6: {
                        Iterator itr = scribbler.scribblerDomains.iterator();
                        List changedResources = anEvent.getChangedResources();
                        Resource resource = null;
                        while (itr.hasNext()) {
                            IScribblerDomain domain = (IScribblerDomain)itr.next();
                            int i = 0;
                            while (i < changedResources.size()) {
                                resource = (Resource)changedResources.get(i);
                                Assert.isTrue(!this.deletedResourceAdapter.isDeleted(resource));
                                if (domain.isContained(resource)) {
                                    this.manageResource(resource, false);
                                }
                                ++i;
                            }
                        }
                        break;
                    }
                }
            }
        }

        public final ResourcePartition partitionResources() {
            HashSet<Resource> modifiedResources = new HashSet<Resource>();
            HashSet<Resource> readOnlyResources = new HashSet<Resource>();
            HashSet<Resource> allDeletedResources = new HashSet<Resource>();
            for (Resource resource : this.resources) {
                if (this.isReadOnly(resource)) {
                    readOnlyResources.add(resource);
                    continue;
                }
                if (!resource.isModified()) continue;
                if (DeletedResourceAdapter.findAdapter(resource) == null) {
                    modifiedResources.add(resource);
                    continue;
                }
                allDeletedResources.add(resource);
            }
            Resource[] modifiedArray = null;
            if (modifiedResources.size() > 0) {
                modifiedArray = modifiedResources.toArray(new Resource[modifiedResources.size()]);
            }
            Resource[] readOnlyArray = null;
            if (readOnlyResources.size() > 0) {
                readOnlyArray = readOnlyResources.toArray(new Resource[readOnlyResources.size()]);
            }
            if (this.deletedResources.size() > 0) {
                allDeletedResources.addAll(this.deletedResources);
            }
            Resource[] deletedArray = null;
            if (allDeletedResources.size() > 0) {
                deletedArray = allDeletedResources.toArray(new Resource[allDeletedResources.size()]);
            }
            return new ResourcePartition(modifiedArray, readOnlyArray, deletedArray);
        }

        public final Set getResources() {
            return Collections.unmodifiableSet(this.resources);
        }

        public boolean hasDeletedResources() {
            return this.deletedResources.size() > 0;
        }

        public boolean isResourceManaged(Resource aResource) {
            return this.resources.contains(aResource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean delete(Resource aResource, IProgressMonitor aMonitor) throws CoreException {
            Assert.isNotNull(this.getEnclosingScribbler());
            EditModelScribbler editModelScribbler = this.getEnclosingScribbler();
            synchronized (editModelScribbler) {
                block4: {
                    this.unprotectedUnmanageResource(aResource);
                    aResource.setModified(true);
                    this.deletedResources.add(aResource);
                    IFile physicalFile = WorkbenchResourceHelper.getFile(aResource);
                    if (!physicalFile.isAccessible()) break block4;
                    physicalFile.delete(true, true, aMonitor);
                    return true;
                }
                return false;
            }
        }

        public void revert(IProgressMonitor aMonitor) throws EditModelException, CoreException {
            if (this.isReadOnly || this.isVaporized) {
                throw new EditModelException(Messages.Cannot_revert_changes_t_);
            }
            ResourcePartition partition = this.partitionResources();
            int i = 0;
            while (i < partition.deletedResources.length) {
                this.deletedResourceAdapter.undeleteResource(partition.deletedResources[i], aMonitor);
                ++i;
            }
            this.editModel.handleRevert(partition.modifiedResources, aMonitor);
            this.deletedResources.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void vaporize() {
            Object lock = this.getEnclosingScribbler();
            if (lock == null) {
                lock = this;
            }
            EditModelScribbler editModelScribbler = lock;
            synchronized (editModelScribbler) {
                if (this.isVaporized) {
                    return;
                }
                this.isVaporized = true;
                EditModelScribbler scribbler = this.getEnclosingScribbler();
                if (scribbler != null) {
                    this.editModel.removeScribbler(scribbler);
                }
                this.editModel.removeListener(this);
                Resource[] managedResources = this.resources.toArray(new Resource[this.resources.size()]);
                int i = 0;
                while (i < managedResources.length) {
                    this.unprotectedUnmanageResource(managedResources[i]);
                    ++i;
                }
            }
        }

        private EditModelScribbler getEnclosingScribbler() {
            return (EditModelScribbler)this.scribblerReference.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageResource(Resource aResource, boolean toProcessResource) {
            Assert.isNotNull(this.getEnclosingScribbler());
            EditModelScribbler editModelScribbler = this.getEnclosingScribbler();
            synchronized (editModelScribbler) {
                if (!this.isResourceManaged(aResource)) {
                    ScribblerAdapter adapter = (ScribblerAdapter)EcoreUtil.getAdapter((List)aResource.eAdapters(), (Object)ScribblerAdapter.ADAPTER_TYPE);
                    Assert.isNotNull((Object)adapter);
                    try {
                        if (this.isReadOnly) {
                            adapter.accessForRead();
                        } else {
                            adapter.accessForWrite();
                        }
                    }
                    catch (EditModelException e) {
                        this.editModel.getErrorHandler().handleGeneralFailure(aResource, e);
                    }
                    this.resources.add(aResource);
                    if (toProcessResource) {
                        this.editModel.enableResourceTracking(aResource);
                    }
                }
            }
        }

        private void unprotectedUnmanageResource(Resource aResource) {
            try {
                Assert.isTrue(this.isResourceManaged(aResource), Messages.An_attempt_was_made_to_r_);
                ScribblerAdapter adapter = (ScribblerAdapter)EcoreUtil.getAdapter((List)aResource.eAdapters(), (Object)ScribblerAdapter.ADAPTER_TYPE);
                Assert.isNotNull((Object)adapter);
                if (this.isReadOnly) {
                    adapter.releaseFromRead();
                } else {
                    adapter.releaseFromWrite();
                }
            }
            catch (EditModelException e) {
                this.editModel.getErrorHandler().handleGeneralFailure(aResource, e);
            }
            this.resources.remove(aResource);
        }

        public boolean isDirty() {
            if (this.isReadOnly) {
                return false;
            }
            if (this.hasDeletedResources()) {
                return true;
            }
            ResourcePartition partition = this.partitionResources();
            Resource[] theResources = partition.modifiedResources;
            int i = 0;
            while (i < theResources.length) {
                Resource resource = theResources[i];
                if (resource.isLoaded() && resource.isModified()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean isReadOnly(Resource resource) {
            return this.readOnlyAdapter.findAdapter(resource) == this.readOnlyAdapter;
        }

        protected static class ResourcePartition {
            private static final Resource[] NO_RESOURCES = new Resource[0];
            protected final Resource[] deletedResources;
            protected final Resource[] modifiedResources;
            protected final Resource[] readOnlyResources;

            protected ResourcePartition(Resource[] modified, Resource[] readOnly, Resource[] deleted) {
                this.modifiedResources = modified != null ? modified : NO_RESOURCES;
                this.deletedResources = deleted != null ? deleted : NO_RESOURCES;
                this.readOnlyResources = readOnly != null ? readOnly : NO_RESOURCES;
            }
        }
    }
}

