/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emfworkbench;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.ResourceIsLoadingAdapter;

public class ResourceSynchronizedIsLoadingAdapter
extends ResourceIsLoadingAdapter {
    private final ILock loadingLock = Platform.getJobManager().newLock();
    private static final long DELAY = 300000L;

    public ResourceSynchronizedIsLoadingAdapter() {
        if (this.loadingLock != null) {
            this.loadingLock.acquire();
        }
    }

    public void waitForResourceToLoad() {
        if (this.loadingLock == null) {
            return;
        }
        boolean lockAcquired = false;
        try {
            try {
                if (this.loadingLock != null && !(lockAcquired = this.loadingLock.acquire(300000L))) {
                    this.logWarning();
                }
            }
            catch (Throwable throwable) {}
        }
        finally {
            if (lockAcquired) {
                this.loadingLock.release();
            }
        }
    }

    private void logWarning() {
        Notifier theTarget = this.getTarget();
        if (theTarget == null || !(theTarget instanceof Resource)) {
            Resource resource = (Resource)theTarget;
            EMFInfrastructurePlugin.log(EMFInfrastructurePlugin.createErrorStatus(0, NLS.bind((String)Messages.Could_not_acquire_Semaphore, (Object[])new Object[]{resource.getURI(), ((Object)((Object)this)).getClass().getName()}), null));
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() != null && this.isSetLoadedResourceNotification(notification)) {
            if (this.loadingLock != null) {
                this.loadingLock.release();
            }
            this.removeIsLoadingSupport();
        }
    }

    public void forceRelease() {
        try {
            if (this.loadingLock != null && this.loadingLock.getDepth() > 0) {
                this.loadingLock.release();
            }
        }
        catch (Throwable throwable) {}
    }
}

