/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.PropertyValue;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.tests.util.AssertionSAXHandler;
import org.eclipse.stp.core.tests.util.XMLAssertions;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class CompositeTest
extends TestCase {
    private IProject project;

    public static void main(String[] args) {
        TestRunner.run(CompositeTest.class);
    }

    public CompositeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("ServiceComponentTest");
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testSimpleJavaComponent() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"/ServiceComponentTest/MyValue.composite");
        Resource res = WorkbenchResourceHelper.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)root);
        Composite composite = fact.createComposite();
        composite.setName("MyValueComposite");
        root.setComposite(composite);
        Component comp = fact.createComponent();
        comp.setName("MyValueComponent");
        JavaImplementation jImpl = fact.createJavaImplementation();
        jImpl.setClass("com.acme.impl.MyValueImpl");
        comp.setSpecializedImplementation((Implementation)jImpl);
        composite.getComponents().add(comp);
        PropertyValue value = fact.createPropertyValue();
        value.setName("test");
        value.setValue((Object)"somePropValue");
        PropertyValuesSet set = fact.createPropertyValuesSet();
        set.getPropertyValues().add(value);
        comp.setPropertyValuesSet(set);
        res.save(null);
        res.unload();
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
        composite = null;
        root = null;
        comp = null;
        res.load(null);
        CompositeTest.assertTrue((res.getContents().size() == 1 ? 1 : 0) != 0);
        CompositeTest.assertTrue((boolean)(res.getContents().get(0) instanceof SCACoreRoot));
        root = (SCACoreRoot)res.getContents().get(0);
        composite = root.getComposite();
        CompositeTest.assertNotNull((Object)composite);
        CompositeTest.assertEquals((String)"MyValueComposite", (String)composite.getName());
        CompositeTest.assertTrue((composite.getComponents().size() == 1 ? 1 : 0) != 0);
        comp = (Component)composite.getComponents().get(0);
        CompositeTest.assertEquals((String)"MyValueComponent", (String)comp.getName());
        CompositeTest.assertEquals((String)"The state should be STATE_IMPLEMENTED.", (int)3, (int)comp.getState());
        CompositeTest.assertEquals((String)"The type should be 'implementation.java'.", (String)"implementation.java", (String)comp.getType());
        CompositeTest.assertTrue((boolean)(comp.getImplementation() instanceof JavaImplementation));
        CompositeTest.assertEquals((String)"com.acme.impl.MyValueImpl", (String)((JavaImplementation)comp.getImplementation()).getClass_());
        List values = comp.getPropertyValuesSet().getPropertyValues();
        CompositeTest.assertTrue((values.size() == 1 ? 1 : 0) != 0);
        value = (PropertyValue)values.get(0);
        CompositeTest.assertEquals((String)"test", (String)value.getName());
        CompositeTest.assertEquals((Object)"somePropValue", (Object)value.getValue());
    }
}

