/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.stp.core.infrastructure.assertion.AssertionFailedException;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaImplementation;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.impl.EntryPointImpl;
import org.eclipse.stp.core.sca.impl.ExternalServiceImpl;
import org.eclipse.stp.core.tests.util.AssertionSAXHandler;
import org.eclipse.stp.core.tests.util.XMLAssertions;

public class UsagePatternTests
extends TestCase {
    private static final String PROJECT_NAME = "UsagePatternTests";
    private IProject project;

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testAcceptsNullEntryPoint_setInterface() throws Exception {
        try {
            EntryPoint point = SCAFactory.eINSTANCE.createEntryPoint();
            point.setInterface(null);
        }
        catch (RuntimeException runtimeException) {
            UsagePatternTests.assertTrue((String)"Problem when calling EntryPoint.setInterface(null).", (boolean)false);
        }
    }

    public void testAcceptsNullExternalService_setInterface() throws Exception {
        try {
            ExternalService extsvc = SCAFactory.eINSTANCE.createExternalService();
            extsvc.setInterface(null);
        }
        catch (RuntimeException runtimeException) {
            UsagePatternTests.assertTrue((String)"Problem when calling EntryPoint.setInterface(null).", (boolean)false);
        }
    }

    public void testResolveComponentType_UncontainedSpecializedComponent() throws Exception {
        try {
            Component component = SCAFactory.eINSTANCE.createComponent();
            JavaImplementation jImpl = SCAFactory.eINSTANCE.createJavaImplementation();
            jImpl.setClass("test");
            component.setSpecializedImplementation((Implementation)jImpl);
            component.resolveComponentType();
        }
        catch (AssertionFailedException assertionFailedException) {
            return;
        }
        UsagePatternTests.assertTrue((String)"An assertion should be thrown for specialized, uncontained components.", (boolean)false);
    }

    public void testResolveComponentType_UncontainedAbstractComponent() throws Exception {
        try {
            Component component = SCAFactory.eINSTANCE.createComponent();
            ComponentType ctype = SCAFactory.eINSTANCE.createComponentType();
            component.setAbstractImplementation(ctype);
            component.resolveComponentType();
        }
        catch (AssertionFailedException assertionFailedException) {
            UsagePatternTests.assertTrue((String)"An assertion should NOT be thrown for abstract, uncontained components.", (boolean)false);
        }
    }

    public void testEntryPoint_setInterfaceMultipleTimes() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"UsagePatternTests/sca.module");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)root);
        Module module = fact.createModule();
        module.setName("TestModule");
        root.setModule(module);
        EntryPoint point = SCAFactory.eINSTANCE.createEntryPoint();
        JavaInterface jInterface1 = SCAFactory.eINSTANCE.createJavaInterface();
        jInterface1.setInterface("org.acme.IJavaInterface");
        point.setInterface((Interface)jInterface1);
        UsagePatternTests.assertEquals((String)"The interface from getInterface() should be the one that was set.", (Object)jInterface1, (Object)point.getInterface());
        JavaInterface jInterface2 = SCAFactory.eINSTANCE.createJavaInterface();
        jInterface2.setInterface("org.acme.IJavaInterface");
        point.setInterface((Interface)jInterface2);
        UsagePatternTests.assertEquals((String)"The interface from getInterface() should be the one that was set.", (Object)jInterface2, (Object)point.getInterface());
        UsagePatternTests.assertEquals((String)"There should be only one interface set", (int)1, (int)((EntryPointImpl)point).getInterfaceGroup().size());
        point.setInterface(null);
        UsagePatternTests.assertEquals((String)"The interface from getInterface() should be null.", null, (Object)point.getInterface());
        UsagePatternTests.assertEquals((String)"There should be NO interface set", (int)0, (int)((EntryPointImpl)point).getInterfaceGroup().size());
        res.save(null);
        res.unload();
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
    }

    public void testExternalService_setInterfaceMultipleTimes() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"UsagePatternTests/sca.module");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)root);
        Module module = fact.createModule();
        module.setName("TestModule");
        root.setModule(module);
        ExternalService extsvc = SCAFactory.eINSTANCE.createExternalService();
        JavaInterface jInterface1 = SCAFactory.eINSTANCE.createJavaInterface();
        jInterface1.setInterface("org.acme.IJavaInterface");
        extsvc.setInterface((Interface)jInterface1);
        UsagePatternTests.assertEquals((String)"The interface from getInterface() should be the one that was set.", (Object)jInterface1, (Object)extsvc.getInterface());
        JavaInterface jInterface2 = SCAFactory.eINSTANCE.createJavaInterface();
        jInterface2.setInterface("org.acme.IJavaInterface");
        extsvc.setInterface((Interface)jInterface2);
        UsagePatternTests.assertEquals((String)"The interface from getInterface() should be the one that was set.", (Object)jInterface2, (Object)extsvc.getInterface());
        UsagePatternTests.assertEquals((String)"There should be only one interface set", (int)1, (int)((ExternalServiceImpl)extsvc).getInterfaceGroup().size());
        extsvc.setInterface(null);
        UsagePatternTests.assertEquals((String)"The interface from getInterface() should be null.", null, (Object)extsvc.getInterface());
        UsagePatternTests.assertEquals((String)"There should be NO interface set", (int)0, (int)((ExternalServiceImpl)extsvc).getInterfaceGroup().size());
        res.save(null);
        res.unload();
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
    }
}

