/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.saf;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.saf.IUIContext;
import org.eclipse.stp.core.saf.exception.InvalidOperationException;
import org.eclipse.stp.core.saf.exception.SAFException;
import org.eclipse.stp.core.saf.handler.AbstractComponentHandler;
import org.eclipse.stp.core.saf.handler.IInterfaceHandler;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.tests.properties.PropertiesImplementation;
import org.eclipse.stp.core.tests.saf.PropComponentCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class PropertiesComponentHandler
extends AbstractComponentHandler {
    public Component createComponent() throws SAFException {
        PropComponentCreationOperation op = new PropComponentCreationOperation(1);
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            return (Component)op.getResult();
        }
        catch (ExecutionException e) {
            throw new SAFException((Throwable)e);
        }
    }

    public boolean canCreateComponentFor(Object implementationObj) {
        return implementationObj != null;
    }

    public SCAObject[] createComponentFor(Object implementationObj, IContainer compositeLocation, IUIContext callback) throws SAFException, InterruptedException {
        try {
            PropComponentCreationOperation op = new PropComponentCreationOperation(2);
            op.setImplObj(implementationObj);
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            return new SCAObject[]{(Component)op.getResult()};
        }
        catch (ExecutionException e) {
            throw new SAFException((Throwable)e);
        }
    }

    public IDataModelOperation createImplementationFor(Component theComponent, IContainer implFileLocation, IUIContext callback) throws SAFException, InterruptedException {
        PropComponentCreationOperation op = new PropComponentCreationOperation(3);
        op.setComponent(theComponent);
        op.setImplFileLocation(implFileLocation);
        return op;
    }

    public IFile[] getImplementationFor(Component theComponent) throws SAFException {
        String fileName = ((PropertiesImplementation)theComponent.getImplementation()).getProperties();
        IFile compositeFile = null;
        IFile implFile = null;
        try {
            compositeFile = this.getIFileForURI(theComponent.getEObject().eResource().getURI());
            implFile = compositeFile.getProject().getFile(fileName);
        }
        catch (IOException e) {
            throw new SAFException("Unable to find implementation", (Throwable)e);
        }
        return new IFile[]{implFile};
    }

    public boolean canSetImplementation() {
        return true;
    }

    public IDataModelOperation setImplementation(Component component, Object implementationObject, IUIContext callback) throws SAFException, InterruptedException {
        PropComponentCreationOperation op = new PropComponentCreationOperation(4);
        op.setComponent(component);
        op.setImplObj(implementationObject);
        return op;
    }

    public boolean isInterfaceKindSupported(IInterfaceHandler interfaceObj, boolean interfaceSet) throws SAFException {
        return interfaceObj.getKind().equals("interface.wsdl") || interfaceObj.getKind().equals("interface.java");
    }

    public void open(Component theComponent) throws SAFException, InvalidOperationException {
    }

    private IFile getIFileForURI(URI uri) throws IOException {
        if (uri == null) {
            return null;
        }
        String filePath = null;
        String scheme = uri.scheme();
        if ("file".equals(scheme)) {
            filePath = uri.toFileString();
        } else if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int i = 1;
            int size = uri.segmentCount();
            while (i < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(uri.segment(i));
                ++i;
            }
            filePath = URI.decode((String)platformResourcePath.toString());
        }
        if (filePath == null) {
            return null;
        }
        IFile file = null;
        if ("file".equals(scheme)) {
            String newPath = filePath.substring(filePath.indexOf(uri.device()), filePath.length());
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(newPath));
        } else {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        }
        try {
            if (file == null) {
                return null;
            }
            if (!(!file.exists() || file.isLocal(1) && file.isSynchronized(1))) {
                file.refreshLocal(1, null);
            }
            return file;
        }
        catch (CoreException exception) {
            throw new Resource.IOWrappedException((Exception)((Object)exception));
        }
    }
}

