/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.resources;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EclipseResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.internal.introspection.ComponentTypeIntrospectorRegistry;
import org.eclipse.stp.core.resources.SOACoreScribblerDomain;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.SCACoreRoot;

public class CompositeScribblerDomain
extends SOACoreScribblerDomain
implements IScribblerDomain {
    private final IFile composite;
    private final IResourceDescriptor[] descriptors;
    private IResourceDescriptor compositeDescriptor;

    public CompositeScribblerDomain(IFile aComposite) {
        super(aComposite.getProject());
        Assert.isTrue(("composite".equals(aComposite.getFileExtension()) || "module".equals(aComposite.getFileExtension()) ? 1 : 0) != 0);
        this.composite = aComposite;
        this.compositeDescriptor = new EclipseResourceDescriptor(this.composite);
        this.descriptors = new IResourceDescriptor[]{this.compositeDescriptor};
    }

    public boolean isContained(Resource aResource) {
        if (super.isContained(aResource)) {
            return true;
        }
        return this.isInterestedInURI(aResource.getURI());
    }

    public boolean isContained(IResourceDescriptor aDescriptor) {
        if (super.isContained(aDescriptor)) {
            return true;
        }
        return this.isInterestedInURI(URI.createPlatformResourceURI((String)aDescriptor.getLocalPath().toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isInterestedInURI(URI uri) {
        IEditModelScribbler scribbler = null;
        try {
            scribbler = this.createScribblerForRead();
            Resource resource = scribbler.getResource(this.getCompositeDescriptor());
            if (resource.getContents().size() <= 0) return false;
            SCACoreRoot root = (SCACoreRoot)resource.getContents().get(0);
            Composite composite = root.getComposite();
            if (composite == null) return false;
            List components = composite.getComponents();
            Component component = null;
            int i = 0;
            while (i < components.size()) {
                component = (Component)components.get(i);
                URI shareableURI = ComponentTypeIntrospectorRegistry.getInstance().getShareableURI(component.getImplementation());
                if (uri.equals((Object)shareableURI)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (EditModelException e) {
            STPCorePlugin.logError(0, e.getMessage(), e);
            return false;
        }
        finally {
            if (scribbler != null) {
                try {
                    scribbler.close(null);
                }
                catch (EditModelException e) {
                    STPCorePlugin.logError(0, e.getMessage(), e);
                }
            }
        }
    }

    public IEditModelScribbler createScribblerForRead() throws EditModelException {
        return IEditModelFactory.eINSTANCE.createScribblerForRead(this.composite.getProject(), (IScribblerDomain)this);
    }

    public IEditModelScribbler createScribblerForWrite() throws EditModelException {
        return IEditModelFactory.eINSTANCE.createScribblerForWrite(this.composite.getProject(), (IScribblerDomain)this);
    }

    public IResourceDescriptor[] getResourceDescriptors() {
        return this.descriptors;
    }

    public IResourceDescriptor getCompositeDescriptor() {
        return this.compositeDescriptor;
    }

    public IProject getProject() {
        return this.composite.getProject();
    }

    public static String generateEditModelLabel(IProject project) {
        return null;
    }
}

