/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.introspection.ModelIntrospectionManager;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IModelIntrospectionManager;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.ImplementationComponent;
import org.eclipse.stp.core.sca.PropertyValuesSet;
import org.eclipse.stp.core.sca.ReferenceValuesSet;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.impl.ComponentImpl;

public class ImplementationComponentImpl
extends ComponentImpl
implements ImplementationComponent {
    public static final String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved.";
    protected FeatureMap implementationGroup = null;
    protected FeatureMap any = null;
    protected FeatureMap anyAttribute = null;
    private ComponentType componentType;

    protected ImplementationComponentImpl() {
    }

    protected EClass eStaticClass() {
        return SCAPackage.eINSTANCE.getImplementationComponent();
    }

    public FeatureMap getImplementationGroup() {
        if (this.implementationGroup == null) {
            this.implementationGroup = new BasicFeatureMap((InternalEObject)this, 3);
        }
        return this.implementationGroup;
    }

    public Implementation getImplementation() {
        return (Implementation)this.getImplementationGroup().get((EStructuralFeature)SCAPackage.eINSTANCE.getImplementationComponent_Implementation(), true);
    }

    public NotificationChain basicSetImplementation(Implementation newImplementation, NotificationChain msgs) {
        return ((FeatureMap.Internal)this.getImplementationGroup()).basicAdd((EStructuralFeature)SCAPackage.eINSTANCE.getImplementationComponent_Implementation(), (Object)newImplementation, msgs);
    }

    public void setImplementationGen(Implementation newImplementation) {
        ((FeatureMap.Internal)this.getImplementationGroup()).set((EStructuralFeature)SCAPackage.eINSTANCE.getImplementationComponent_Implementation(), (Object)newImplementation);
    }

    public FeatureMap getAny() {
        if (this.any == null) {
            this.any = new BasicFeatureMap((InternalEObject)this, 5);
        }
        return this.any;
    }

    public FeatureMap getAnyAttribute() {
        if (this.anyAttribute == null) {
            this.anyAttribute = new BasicFeatureMap((InternalEObject)this, 6);
        }
        return this.anyAttribute;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 1: {
                    if (this.referenceValuesSet != null) {
                        msgs = ((InternalEObject)this.referenceValuesSet).eInverseRemove((InternalEObject)this, -2, null, msgs);
                    }
                    return this.basicSetReferenceValuesSet((ReferenceValuesSet)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return this.basicSetPropertyValuesSet(null, msgs);
                }
                case 1: {
                    return this.basicSetReferenceValuesSet(null, msgs);
                }
                case 3: {
                    return ((InternalEList)this.getImplementationGroup()).basicRemove((Object)otherEnd, msgs);
                }
                case 4: {
                    return this.basicSetImplementation(null, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getAny()).basicRemove((Object)otherEnd, msgs);
                }
                case 6: {
                    return ((InternalEList)this.getAnyAttribute()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getPropertyValuesSet();
            }
            case 1: {
                return this.getReferenceValuesSet();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getImplementationGroup();
            }
            case 4: {
                return this.getImplementation();
            }
            case 5: {
                return this.getAny();
            }
            case 6: {
                return this.getAnyAttribute();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setPropertyValuesSet((PropertyValuesSet)newValue);
                return;
            }
            case 1: {
                this.setReferenceValuesSet((ReferenceValuesSet)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getImplementationGroup().clear();
                this.getImplementationGroup().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setImplementation((Implementation)newValue);
                return;
            }
            case 5: {
                this.getAny().clear();
                this.getAny().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getAnyAttribute().clear();
                this.getAnyAttribute().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setPropertyValuesSet(null);
                return;
            }
            case 1: {
                this.setReferenceValuesSet(null);
                return;
            }
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getImplementationGroup().clear();
                return;
            }
            case 4: {
                this.setImplementation(null);
                return;
            }
            case 5: {
                this.getAny().clear();
                return;
            }
            case 6: {
                this.getAnyAttribute().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.propertyValuesSet != null;
            }
            case 1: {
                return this.referenceValuesSet != null;
            }
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.implementationGroup != null && !this.implementationGroup.isEmpty();
            }
            case 4: {
                return this.getImplementation() != null;
            }
            case 5: {
                return this.any != null && !this.any.isEmpty();
            }
            case 6: {
                return this.anyAttribute != null && !this.anyAttribute.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (implementationGroup: ");
        result.append(this.implementationGroup);
        result.append(", any: ");
        result.append(this.any);
        result.append(", anyAttribute: ");
        result.append(this.anyAttribute);
        result.append(')');
        return result.toString();
    }

    public void setImplementation(Implementation newImplementation) {
        ((FeatureMap.Internal)this.getImplementationGroup()).set((EStructuralFeature)SCAPackage.eINSTANCE.getImplementationComponent_Implementation(), (Object)newImplementation);
    }

    public Implementation setSpecializedImplementation(Implementation newImplementation) {
        EStructuralFeature feature = FeatureAdapter.getFeature(newImplementation);
        Assert.isNotNull((Object)feature);
        Implementation oldImplementation = null;
        FeatureMap.Internal featureMap = (FeatureMap.Internal)this.getImplementationGroup();
        if (featureMap.isEmpty()) {
            featureMap.add(feature, (Object)newImplementation);
        } else {
            FeatureMap.Entry entry = (FeatureMap.Entry)featureMap.remove(0);
            oldImplementation = (Implementation)entry.getValue();
            featureMap.add(feature, (Object)newImplementation);
        }
        this.componentType = null;
        return oldImplementation;
    }

    public Implementation setAbstractImplementation(ComponentType newComponentType) {
        IComponentTypeIntrospector introspector;
        FeatureMap.Entry entry;
        Implementation currentImplementation = null;
        FeatureMap.Internal implementationGroup = (FeatureMap.Internal)this.getImplementationGroup();
        if (!implementationGroup.isEmpty() && FeatureAdapter.getFeature(currentImplementation = (Implementation)(entry = (FeatureMap.Entry)implementationGroup.remove(0)).getValue()) == null) {
            FeatureAdapter.setFeature(currentImplementation, entry.getEStructuralFeature());
        }
        if ((introspector = (IComponentTypeIntrospector)EcoreUtil.getAdapter((List)newComponentType.getEObject().eAdapters(), (Object)IComponentTypeIntrospector.ADAPTER_TYPE)) != null) {
            newComponentType.getEObject().eAdapters().remove((Object)introspector);
            introspector.dispose();
        }
        AbstractImplementation abstractImplementation = SCAFactory.eINSTANCE.createAbstractImplementation();
        abstractImplementation.setComponentType(newComponentType);
        this.getImplementationGroup().set((EStructuralFeature)SCAPackage.eINSTANCE.getSCACoreRoot_ImplementationAbstract(), (Object)abstractImplementation);
        return currentImplementation;
    }

    public int getState() {
        Implementation impl = this.getImplementation();
        if (impl == null) {
            return 1;
        }
        if (impl instanceof AbstractImplementation) {
            AbstractImplementation abstractImplementation = (AbstractImplementation)impl;
            if (abstractImplementation.getType() != null) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    public String getType() {
        switch (this.getState()) {
            case 2: {
                AbstractImplementation impl = (AbstractImplementation)this.getImplementation();
                return impl.getType();
            }
            case 3: {
                EStructuralFeature feature = this.getImplementationFeature();
                Assert.isNotNull((Object)feature);
                return ExtendedMetaData.INSTANCE.getName(feature);
            }
        }
        return "implementation.abstract";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentType resolveComponentType() {
        if (this.componentType != null) {
            return this.componentType;
        }
        ImplementationComponentImpl implementationComponentImpl = this;
        synchronized (implementationComponentImpl) {
            boolean hasAbstractImplementation = this.hasAbstractImplementation();
            Assert.isTrue((hasAbstractImplementation || this.eResource() != null && this.eResource().getResourceSet() != null ? 1 : 0) != 0);
            if (hasAbstractImplementation) {
                this.componentType = this.resolveAbstractComponentType();
            } else if (this.componentType == null && !this.getImplementationGroup().isEmpty()) {
                this.componentType = IModelIntrospectionManager.eINSTANCE.resolve(this.getImplementation());
            }
        }
        return this.componentType;
    }

    private EStructuralFeature getImplementationFeature() {
        return ModelIntrospectionManager.getStructuralFeature(this.getImplementation());
    }

    private ComponentType resolveAbstractComponentType() {
        AbstractImplementation abstractImpl = (AbstractImplementation)this.getImplementation();
        return abstractImpl == null ? null : abstractImpl.getComponentType();
    }

    private boolean hasAbstractImplementation() {
        Implementation impl = this.getImplementation();
        return impl != null && impl instanceof AbstractImplementation;
    }
}

