/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.create.operations.ComponentCreationDataModelProvider;
import org.eclipse.stp.core.create.operations.ComponentTypeCreationDataModelProvider;
import org.eclipse.stp.core.create.operations.CompositeCreationDataModelProvider;
import org.eclipse.stp.core.create.operations.ModuleCreationDataModelProvider;
import org.eclipse.stp.core.create.operations.PropertyCreationDataModelProvider;
import org.eclipse.stp.core.create.operations.ReferenceCreationDataModelProvider;
import org.eclipse.stp.core.create.operations.ServiceCreationDataModelProvider;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.resources.ComponentTypeScribblerDomain;
import org.eclipse.stp.core.resources.CompositeScribblerDomain;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Composite;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.util.IModelLifecycle;
import org.eclipse.stp.core.util.ModelLifecycleException;
import org.eclipse.stp.core.util.SCAType;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SCAArtifactEdit
implements IModelLifecycle {
    private static final String EDIT_MODEL_SUFFIX = ".soaeditmodel";
    private IEditModelScribbler scribbler = null;
    private boolean isArtifactEditModelSelfManaged;
    private CompositeScribblerDomain compositeDomain;
    private ComponentTypeScribblerDomain componentTypeDomain;

    public SCAArtifactEdit(IEditModelScribbler aScribbler) {
        this.scribbler = aScribbler;
        this.isArtifactEditModelSelfManaged = false;
    }

    protected SCAArtifactEdit(IProject aProject, CompositeScribblerDomain aCompositeDomain, ComponentTypeScribblerDomain aComponentTypeDomain, boolean toAccessAsReadOnly) {
        Assert.isNotNull((Object)((Object)aCompositeDomain));
        this.compositeDomain = aCompositeDomain;
        this.componentTypeDomain = aComponentTypeDomain;
        String editModelLabel = String.valueOf(aProject.getName()) + EDIT_MODEL_SUFFIX;
        try {
            this.scribbler = toAccessAsReadOnly ? IEditModelFactory.eINSTANCE.createScribblerForRead(aProject, editModelLabel, new IScribblerDomain[]{aCompositeDomain, aComponentTypeDomain}) : IEditModelFactory.eINSTANCE.createScribblerForWrite(aProject, editModelLabel, new IScribblerDomain[]{aCompositeDomain, aComponentTypeDomain});
        }
        catch (EditModelException editModelException) {}
        this.isArtifactEditModelSelfManaged = true;
    }

    public static SCAArtifactEdit createArtifactEditForRead(IProject aProject, CompositeScribblerDomain aCompositeDomain, ComponentTypeScribblerDomain aComponentTypeDomain) {
        SCAArtifactEdit scaArtifactEdit = null;
        try {
            scaArtifactEdit = new SCAArtifactEdit(aProject, aCompositeDomain, aComponentTypeDomain, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            scaArtifactEdit = null;
        }
        return scaArtifactEdit;
    }

    public static SCAArtifactEdit createArtifactEditForWrite(IProject aProject, CompositeScribblerDomain aCompositeDomain, ComponentTypeScribblerDomain aComponentTypeDomain) {
        SCAArtifactEdit scaArtifactEdit = null;
        try {
            scaArtifactEdit = new SCAArtifactEdit(aProject, aCompositeDomain, aComponentTypeDomain, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            scaArtifactEdit = null;
        }
        return scaArtifactEdit;
    }

    public void save(int options, IProgressMonitor aMonitor) throws ModelLifecycleException {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        try {
            this.scribbler.save(true, aMonitor);
        }
        catch (EditModelException e) {
            throw new ModelLifecycleException(e);
        }
    }

    public void close(int options, IProgressMonitor aMonitor) throws ModelLifecycleException {
        try {
            if (this.isArtifactEditModelSelfManaged) {
                this.scribbler.close(aMonitor);
            }
        }
        catch (EditModelException e) {
            e.printStackTrace();
        }
    }

    public void discard(IProgressMonitor aMonitor) throws ModelLifecycleException {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        try {
            this.scribbler.revert(aMonitor);
        }
        catch (EditModelException e) {
            throw new ModelLifecycleException(e);
        }
    }

    public void revert(int options, IProgressMonitor aMonitor) throws ModelLifecycleException {
        if (this.isReadOnly()) {
            this.throwAttemptedReadOnlyModification();
        }
        try {
            this.scribbler.revert(aMonitor);
        }
        catch (EditModelException e) {
            throw new ModelLifecycleException(e);
        }
    }

    public boolean isReadOnly() {
        return this.scribbler.isReadOnly();
    }

    private void throwAttemptedReadOnlyModification() {
        throw new IllegalStateException(Messages.Attempt_to_modify_an_SCA_);
    }

    public static IDataModel getDataModelForCreation(String type, IProject aProject) {
        Class dataModelClass = null;
        if (type.equals(SCAType.COMPONENT_TYPE)) {
            dataModelClass = ComponentTypeCreationDataModelProvider.class;
        } else if (type.equals("COMPOSITE")) {
            dataModelClass = CompositeCreationDataModelProvider.class;
        } else if (type.equals("MODULE")) {
            dataModelClass = ModuleCreationDataModelProvider.class;
        } else if (type.equals("COMPONENT")) {
            dataModelClass = ComponentCreationDataModelProvider.class;
        } else if (type.equals("REFERENCE")) {
            dataModelClass = ReferenceCreationDataModelProvider.class;
        } else if (type.equals("INTERFACE")) {
            dataModelClass = ServiceCreationDataModelProvider.class;
        } else if (type.equals("PROPERTY")) {
            dataModelClass = PropertyCreationDataModelProvider.class;
        }
        if (dataModelClass != null) {
            IDataModel model = DataModelFactory.createDataModel(dataModelClass);
            Assert.isNotNull((Object)model, (String)Messages.DataModel_could_not_be_c_);
            return model;
        }
        return null;
    }

    public ComponentType getComponentType() {
        Resource resource = this.scribbler.getResource((IResourceDescriptor)this.componentTypeDomain.getComponentTypeDescriptor());
        return (ComponentType)this.getFirstInstanceOfEObjectFromResource(SCAPackage.eINSTANCE.getComponentType(), resource);
    }

    public Composite getComposite() {
        Resource resource = this.scribbler.getResource(this.compositeDomain.getCompositeDescriptor());
        return (Composite)this.getFirstInstanceOfEObjectFromResource(SCAPackage.eINSTANCE.getComposite(), resource);
    }

    public EObject getRootSCAObject(URI scaObjectURI) {
        Assert.isNotNull((Object)this.scribbler);
        Resource resource = this.scribbler.getResource(scaObjectURI);
        return this.getRootSCAObject(resource);
    }

    public EObject getRootSCAObject(Resource rootResource) {
        SCAPackage scdlPkg = SCAPackage.eINSTANCE;
        EClass eClass = null;
        String ext = rootResource.getURI().fileExtension();
        Assert.isNotNull((Object)ext);
        if (ext.equals("componentType")) {
            eClass = scdlPkg.getComponent();
        } else if (ext.equals("composite")) {
            eClass = scdlPkg.getComposite();
        }
        Assert.isNotNull((Object)this.scribbler);
        return this.getFirstInstanceOfEObjectFromResource(eClass, rootResource);
    }

    public EObject getFirstInstanceOfEObjectFromResource(EClass eClass, Resource resource) {
        if (resource == null) {
            return null;
        }
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!element.eClass().equals(eClass)) continue;
            return element;
        }
        return null;
    }
}

