/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.soas.deploy.tomcat;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConstructor;
import org.eclipse.stp.soas.deploy.core.IPackageCreationContext;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.ServerType;
import org.eclipse.stp.soas.deploy.core.Version;

public class WarDeployFilePackageConstructor implements IPackageConstructor {

	public IPackageOutputDescriptor createPackage(ILogicalPackage pkg,
			IPackageCreationContext context, IPackageConfiguration configuration)
			throws CoreException {
		
		    IFile deployFile = pkg.getFile();
		    
		    return new WarPackageOutputDescriptor(deployFile.getRawLocation().toFile(),
                    pkg.getTechnologyType(),
                    new ServerType("org.eclipse.stp.soas.deploy.tomcat.tomcatContainer",
                                   new Version(5, 5, 0, new String())),
                    deployFile.getRawLocation().toFile().getPath(),
                    deployFile.getName());
	}
		
}
