/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;

public class ResizableLaneEditPolicy
extends ResizableShapeEditPolicyEx {
    protected Handle createHandle(GraphicalEditPart owner, int direction) {
        return new LaneResizeHandle(owner, direction);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(new Point(0, req.getMoveDelta().y));
        req.setSizeDelta(new Dimension(0, req.getSizeDelta().height));
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(5);
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle)handle;
            h.setDragTracker((DragTracker)new DragEditPartsTrackerEx(this.getHost()){

                protected void addSourceCommands(boolean isMove, CompoundCommand command) {
                    if (!this.isCloneActive()) {
                        Request request = this.getTargetRequest();
                        request.setType((Object)(isMove ? "move" : "drag"));
                        command.add(ResizableLaneEditPolicy.this.getHost().getCommand(request));
                        request.setType((Object)"drop");
                    } else {
                        super.addSourceCommands(isMove, command);
                    }
                }
            });
        }
    }

    protected static class LaneResizeHandle
    extends ResizableShapeEditPolicyEx.ResizeHandleEx {
        public LaneResizeHandle(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected DragTracker createDragTracker() {
            return new ResizeTracker(this.getOwner(), this.cursorDirection);
        }
    }
}

