/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.assertion.AssertionFailedException;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.saf.exception.SAFException;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ComponentTypingOperation
extends AbstractDataModelOperation {
    private Component component;
    private Implementation oldImplementation;
    private boolean setType = false;
    private String type = null;
    private String oldType = null;

    public ComponentTypingOperation(IDataModel operationDataModel) {
        super(operationDataModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.component = (Component)this.model.getProperty("IComponentTypingDataModelProperties.COMPONENT");
        this.setType = this.model.getBooleanProperty("IComponentTypingDataModelProperties.SET_TYPE");
        this.type = this.model.getStringProperty("IComponentTypingDataModelProperties.TYPE");
        this.oldImplementation = this.component.getImplementation();
        if (this.setType) {
            if (this.oldImplementation == null) {
                this.component.setAbstractImplementation(SCAFactory.eINSTANCE.createComponentType());
                AbstractImplementation impl = (AbstractImplementation)this.component.getImplementation();
                impl.setType(this.type);
                return Status.OK_STATUS;
            }
            if (this.oldImplementation instanceof AbstractImplementation) {
                this.oldType = ((AbstractImplementation)this.oldImplementation).getType();
                ((AbstractImplementation)this.oldImplementation).setType(this.type);
                return Status.OK_STATUS;
            }
            String message = NLS.bind((String)Messages.stp_core_saf_unableToSetKindForTypedComponent, (Object)this.type);
            throw new ExecutionException(message, (Throwable)new SAFException());
        }
        if (this.oldImplementation instanceof AbstractImplementation) {
            this.oldType = ((AbstractImplementation)this.oldImplementation).getType();
            ((AbstractImplementation)this.oldImplementation).setType(null);
            return Status.OK_STATUS;
        }
        if (this.oldImplementation == null) {
            this.component.setAbstractImplementation(SCAFactory.eINSTANCE.createComponentType());
            return Status.OK_STATUS;
        }
        ComponentType compType = null;
        try {
            compType = this.component.resolveComponentType();
        }
        catch (AssertionFailedException assertionFailedException) {
            compType = SCAFactory.eINSTANCE.createComponentType();
        }
        this.component.setAbstractImplementation(compType);
        return Status.OK_STATUS;
    }

    public boolean canRedo() {
        return false;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.setType) {
            if (this.oldImplementation == null) {
                this.component.setAbstractImplementation(null);
            } else if (this.oldImplementation instanceof AbstractImplementation) {
                ((AbstractImplementation)this.oldImplementation).setType(this.oldType);
            }
        } else if (this.oldImplementation instanceof AbstractImplementation) {
            ((AbstractImplementation)this.oldImplementation).setType(this.oldType);
        } else if (this.oldImplementation == null) {
            this.component.setAbstractImplementation(null);
        } else {
            this.component.setSpecializedImplementation(this.oldImplementation);
        }
        return Status.OK_STATUS;
    }
}

