/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.edit.operations;

import java.util.List;
import java.util.Set;
import org.apache.xerces.util.XMLChar;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.core.edit.operations.ChangeSCAObjectNameOperation;
import org.eclipse.stp.core.edit.operations.IChangeSCAObjectNameDataModelProperties;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class ChangeSCAObjectNameDataModelProvider
extends AbstractScribblerDataModelProvider
implements IChangeSCAObjectNameDataModelProperties {
    protected static final String URI_RESTRICTED_CHARACTERS = ":?#@!";

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IChangeSCAObjectNameDataModelProperties.SCAOBJECT");
        propertyNames.add("IChangeSCAObjectNameDataModelProperties.NEW_NAME");
        propertyNames.add("IChangeSCAObjectNameDataModelProperties.EXISTING_SCAOBJECTS");
        return propertyNames;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IChangeSCAObjectNameDataModelProperties.SCAOBJECT")) {
            this.validateSCAObject();
        } else if (propertyName.equals("IChangeSCAObjectNameDataModelProperties.NEW_NAME")) {
            return this.validateNewName();
        }
        return super.validate(propertyName);
    }

    public IDataModelOperation getDefaultOperation() {
        return new ChangeSCAObjectNameOperation(this.model);
    }

    private IStatus validateSCAObject() {
        Object part = this.getProperty("IChangeSCAObjectNameDataModelProperties.SCAOBJECT");
        if (!(part instanceof SCAObject)) {
            return STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText, null);
        }
        return OK_STATUS;
    }

    private IStatus checkForDuplicate() {
        List list = (List)this.getProperty("IChangeSCAObjectNameDataModelProperties.EXISTING_SCAOBJECTS");
        if (list != null) {
            SCAObject scaObject = (SCAObject)this.getProperty("IChangeSCAObjectNameDataModelProperties.SCAOBJECT");
            String newName = this.getStringProperty("IChangeSCAObjectNameDataModelProperties.NEW_NAME");
            int x = 0;
            while (x < list.size()) {
                SCAObject object = (SCAObject)list.get(x);
                if (scaObject != object && newName != null && newName.equals(object.getName())) {
                    return STPCorePlugin.createErrorStatus(Messages.Name_Already_Exists, null);
                }
                ++x;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus validateNewName() {
        String newName = this.getStringProperty("IChangeSCAObjectNameDataModelProperties.NEW_NAME");
        if (newName == null || newName.length() <= 0) {
            return STPCorePlugin.createErrorStatus(Messages.newNameBlank_errorText, null);
        }
        SCAObject scaObject = (SCAObject)this.getProperty("IChangeSCAObjectNameDataModelProperties.SCAOBJECT");
        if (scaObject.getName().equals(newName)) {
            return STPCorePlugin.createErrorStatus(Messages.Existing_name_is_same_as_, null);
        }
        IStatus result = ResourcesPlugin.getWorkspace().validateName(newName, 1);
        if (result.isOK()) {
            result = this.checkForSpecialURICharacters(newName);
        }
        if (result.isOK()) {
            result = this.checkForDuplicate();
        }
        return result;
    }

    private IStatus checkForSpecialURICharacters(String name) {
        if (!XMLChar.isValidNCName((String)name)) {
            return STPCorePlugin.createErrorStatus(Messages.bind((String)Messages.nameNotValid_errorText, (Object)name), null);
        }
        int i = 0;
        while (i < URI_RESTRICTED_CHARACTERS.length()) {
            if (name.indexOf(URI_RESTRICTED_CHARACTERS.charAt(i)) != -1) {
                return STPCorePlugin.createErrorStatus(Messages.bind((String)Messages.portionOfNameNotValid_errorText, (Object)name, (Object)String.valueOf(URI_RESTRICTED_CHARACTERS.charAt(i))), null);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

