/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.views;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.views.AnnotationView;

class AnnotationViewerContentProvider
implements ITreeContentProvider {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(AnnotationViewerContentProvider.class);
    private AnnotationView parent;

    public AnnotationViewerContentProvider(AnnotationView aParent) {
        this.parent = aParent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] getChildren(Object node) {
        if (node instanceof Class) {
            return ((Class)node).getDeclaredMethods();
        }
        if (node instanceof Method) {
            Method method = (Method)node;
            Class<?> returnType = method.getReturnType();
            if (!returnType.isArray()) return null;
            Class<?> annoClass = method.getDeclaringClass();
            Annotation annoNode = this.parent.annotationNodesMap.get(annoClass.getSimpleName());
            if (annoNode == null) {
                annoNode = this.parent.annotationNodesMap.get(annoClass.getName());
            }
            if (annoNode != null) {
                if (!(annoNode instanceof NormalAnnotation)) return null;
                MemberValuePair mvpOne = null;
                for (Object obj : ((NormalAnnotation)annoNode).values()) {
                    MemberValuePair mvp = (MemberValuePair)obj;
                    if (!mvp.getName().getIdentifier().equals(method.getName())) continue;
                    mvpOne = mvp;
                    break;
                }
                if (mvpOne == null) return null;
                ArrayInitializer arrayInit = (ArrayInitializer)mvpOne.getValue();
                int number = arrayInit.expressions().size();
                Object[] children = new Object[number + 1];
                int i = 0;
                while (i < children.length) {
                    children[i] = new Object[2];
                    ++i;
                }
                Arrays.sort(children, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                i = 0;
                while (i < number) {
                    Object[] pair = (Object[])children[i];
                    pair[0] = String.valueOf(returnType.getComponentType().getCanonicalName()) + ":Existing" + i;
                    pair[1] = arrayInit.expressions().get(i);
                    ++i;
                }
                Object[] pair = (Object[])children[number];
                pair[0] = String.valueOf(returnType.getComponentType().getCanonicalName()) + ":ClickToAdd";
                pair[1] = null;
                return children;
            }
            Object[] pair = new Object[]{String.valueOf(returnType.getComponentType().getCanonicalName()) + ":ClickToAdd", null};
            Object[] children = new Object[]{pair};
            return children;
        }
        if (!(node instanceof Object[])) return null;
        Object[] pair = (Object[])node;
        if (pair[0] instanceof String) {
            String str = (String)pair[0];
            NormalAnnotation anno = (NormalAnnotation)pair[1];
            String className = str.substring(0, str.indexOf(":"));
            try {
                Method[] methods = Class.forName(className).getDeclaredMethods();
                Arrays.sort(methods, new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        return m1.toString().compareTo(m2.toString());
                    }
                });
                Object[] children = new Object[methods.length];
                int i = 0;
                while (i < methods.length) {
                    children[i] = new Object[2];
                    ++i;
                }
                Arrays.sort(children, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                i = 0;
                while (i < methods.length) {
                    Method method = methods[i];
                    Object[] sub = (Object[])children[i];
                    sub[0] = method;
                    sub[1] = null;
                    if (anno != null) {
                        for (Object obj : anno.values()) {
                            MemberValuePair mvp2 = (MemberValuePair)obj;
                            if (!mvp2.getName().getIdentifier().equals(method.getName())) continue;
                            sub[1] = mvp2;
                            break;
                        }
                    }
                    ++i;
                }
                return children;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        if (!(pair[0] instanceof Method)) return null;
        return null;
    }

    public Object getParent(Object arg0) {
        return null;
    }

    public boolean hasChildren(Object arg0) {
        Object[] pair;
        if (arg0 instanceof Class) {
            return true;
        }
        return arg0 instanceof Method ? ((Method)arg0).getReturnType().isArray() : arg0 instanceof Object[] && (pair = (Object[])arg0)[0] instanceof String;
    }

    public Object[] getElements(Object input) {
        try {
            IProject project;
            if (input instanceof IMethod) {
                IMethod method = (IMethod)input;
                IProject project2 = method.getUnderlyingResource().getProject();
                List<Class> list = ScAnnotationSupportUtils.getAvailableAnnotationsForMethod(project2);
                LOG.debug((Object)("retrieved methods annotations: " + list));
                return list.toArray();
            }
            if (input instanceof IType) {
                IType type = (IType)input;
                project = type.getUnderlyingResource().getProject();
                if (type.isAnnotation()) {
                    return ScAnnotationSupportUtils.getAvailableAnnotationsForAnno(project).toArray();
                }
                if (type.isClass()) {
                    return ScAnnotationSupportUtils.getAvailableAnnotationsForClass(project).toArray();
                }
                if (type.isInterface()) {
                    return ScAnnotationSupportUtils.getAvailableAnnotationsForInterface(project).toArray();
                }
            }
            if (input instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration var = (SingleVariableDeclaration)input;
                CompilationUnit root = (CompilationUnit)var.getRoot();
                IProject project3 = root.getJavaElement().getCorrespondingResource().getProject();
                return ScAnnotationSupportUtils.getAvailableAnnotationsForParam(project3).toArray();
            }
            if (input instanceof IField) {
                IField field = (IField)input;
                project = field.getUnderlyingResource().getProject();
                return ScAnnotationSupportUtils.getAvailableAnnotationsForField(project).toArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }
}

