/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.views;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.views.AnnotationView;
import org.eclipse.swt.graphics.Image;

class AnnotationViewerLabelProvider
implements ITableLabelProvider {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(AnnotationViewerLabelProvider.class);
    private AnnotationView parent;

    public AnnotationViewerLabelProvider(AnnotationView aParent) {
        this.parent = aParent;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Object[] pair;
        if (columnIndex != 0) {
            return null;
        }
        if (element instanceof Class) {
            return this.isAnnotationDeclaredForElement((Class)element) ? this.parent.iconOn : this.parent.iconOff;
        }
        if (element instanceof Object[] && (pair = (Object[])element)[0] instanceof String) {
            return ((String)pair[0]).indexOf(":Existing") >= 0 ? this.parent.iconOn : this.parent.iconOff;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Class) {
            Class annotationClass = (Class)element;
            switch (columnIndex) {
                case 0: {
                    return annotationClass.getName();
                }
                case 1: {
                    return "" + this.isAnnotationDeclaredForElement(annotationClass);
                }
            }
            return "";
        }
        if (element instanceof Method) {
            Method theMethod = (Method)element;
            switch (columnIndex) {
                case 0: {
                    return theMethod.getName();
                }
                case 1: {
                    String completeTextValue = this.getCurrentpropertyValue(theMethod);
                    if (completeTextValue == null || completeTextValue.equals("")) {
                        return null;
                    }
                    if (completeTextValue.startsWith("\"") && completeTextValue.endsWith("\"") && completeTextValue.length() >= 2) {
                        return completeTextValue.substring(1, completeTextValue.length() - 1);
                    }
                    if (completeTextValue.toLowerCase().indexOf(String.valueOf(theMethod.getName().toLowerCase()) + ".") > -1) {
                        return completeTextValue.substring(1 + completeTextValue.lastIndexOf(46));
                    }
                    return completeTextValue;
                }
            }
            return "";
        }
        if (element instanceof Object[]) {
            Object[] pair = (Object[])element;
            if (pair[0] instanceof String) {
                String className = (String)pair[0];
                int index = className.indexOf(":");
                className = className.substring(0, index);
                switch (columnIndex) {
                    case 0: {
                        return className;
                    }
                    case 1: {
                        return "" + (((String)pair[0]).indexOf(":Existing") >= 0);
                    }
                }
                return "";
            }
            if (pair[0] instanceof Method) {
                Method method = (Method)pair[0];
                switch (columnIndex) {
                    case 0: {
                        return method.getName();
                    }
                    case 1: {
                        String value = "";
                        if (pair[1] != null) {
                            MemberValuePair mvp = (MemberValuePair)pair[1];
                            Expression expression = mvp.getValue();
                            if (expression instanceof StringLiteral) {
                                StringLiteral sl = (StringLiteral)expression;
                                value = sl.getEscapedValue();
                                value = value.substring(1, value.length() - 1);
                            } else {
                                value = expression.toString();
                            }
                        }
                        return value;
                    }
                }
                return "";
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    private boolean isAnnotationDeclaredForElement(Class annotationClass) {
        return this.parent.annotationNodesMap.get(annotationClass.getSimpleName()) != null || this.parent.annotationNodesMap.get(annotationClass.getName()) != null;
    }

    private String getCurrentpropertyValue(Method attributeAccessor) {
        String annotationClassName = attributeAccessor.getDeclaringClass().getSimpleName();
        Annotation genericAnnotation = this.parent.annotationNodesMap.get(annotationClassName);
        if (genericAnnotation == null) {
            annotationClassName = attributeAccessor.getDeclaringClass().getName();
            genericAnnotation = this.parent.annotationNodesMap.get(annotationClassName);
        }
        if (genericAnnotation == null) {
            return null;
        }
        if (genericAnnotation instanceof NormalAnnotation) {
            NormalAnnotation currentAnnotation = (NormalAnnotation)genericAnnotation;
            for (MemberValuePair attribute : currentAnnotation.values()) {
                LOG.debug((Object)("attribute Name : " + attribute.getName()));
                LOG.debug((Object)("attribute type : " + attribute.getValue().getClass().getCanonicalName()));
                LOG.debug((Object)("attribute value : " + attribute.getValue().toString()));
                if (!attribute.getName().getIdentifier().equals(attributeAccessor.getName())) continue;
                return attribute.getValue().toString();
            }
        }
        if (genericAnnotation instanceof SingleMemberAnnotation) {
            return ((SingleMemberAnnotation)genericAnnotation).getValue().toString();
        }
        return null;
    }
}

