/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.workspace;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractNature
implements IProjectNature {
    private IProject project;

    public abstract String getNatureID();

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void addToProject(IProject project) throws CoreException {
        if (!project.hasNature(this.getNatureID())) {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = this.getNatureID();
            desc.setNatureIds(newNatures);
            project.setDescription(desc, null);
        }
    }

    public void removeFromProject(IProject project) throws CoreException {
        if (project.hasNature(this.getNatureID())) {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            ArrayList newNatures = new ArrayList(Arrays.asList(natures));
            newNatures.remove(newNatures.indexOf(this.getNatureID()));
            desc.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
            project.setDescription(desc, null);
        }
    }

    public boolean hasNature(IProject aProject) throws CoreException {
        return aProject.hasNature(this.getNatureID());
    }
}

