/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.common.annotations.ext;

import java.lang.annotation.Annotation;
import java.util.List;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

public interface IAnnotationInitializer {

    /**
     * defines the defaults attributes of a newly generated annotation within a specific java document.
     * usually used to pull preference settings or to compute basic values from the java member to which the 
     * annotation is attached
     * @param annotationClass the class defining the annotation we want to generate
     * @param astRoot the compilation unit of the java document in which the annotation will be added
     * @param jdtMember the java member onto which we want to add the annotation
     * @param jdtMemberParam the exact sub-element of the java member onto which to add the annotation (so far 
     * it's only been meaningfull for method Parameters)... can be null...
     * @return the <code>List</code> default attributes for the specified annotation node
     */
    List<MemberValuePair> getDefaultAttributes(Class<? extends Annotation> annotationClass,
                                               CompilationUnit astRoot,
                                               IMember jdtMember,
                                               SingleVariableDeclaration jdtMemberParam);
}
