/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.builders;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.builders.ScJavaBuilder;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.builders.JavaDocumentUtils;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IJavaToWsdlGenerator;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class ScJavaToWsdlBuilder
extends ScJavaBuilder {
    public static final String BUILDER_ID = "org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJavaToWsdlBuilder.class);

    public ScJavaToWsdlBuilder() {
        LOG.debug((Object)"JavaToWSDL builder has been created");
    }

    protected void buildOneJavaFile(IFile javaFile) throws CoreException {
        try {
            if (javaFile.getFileExtension() == null || !javaFile.getFileExtension().equals("java")) {
                return;
            }
            this.generate(javaFile.getFullPath(), this.getProject(), null);
        }
        catch (Exception e) {
            LOG.debug((Object)"generation failure", (Throwable)e);
            Status status = new Status(4, "org.eclipse.core.resources", 75, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void generate(IPath path, IProject project, Object data) throws CoreException {
        boolean isAutoBuild = WorkspaceManager.getWorkspaceAutoBuild();
        try {
            if (isAutoBuild) {
                LOG.debug((Object)"disable workspace autobuild before generating code");
                WorkspaceManager.setWorkspaceAutoBuild((boolean)false);
            }
            IJavaToWsdlGenerator generator = ScJaxWsPlugin.getRuntimeProviderManager().getJavaToWsdlGenerator(project);
            if (data != null) {
                generator.setInitializationData(null, null, data);
            }
            generator.run(path, project);
        }
        finally {
            if (isAutoBuild) {
                LOG.debug((Object)"re-enable workspace autobuild after generating code");
                WorkspaceManager.setWorkspaceAutoBuild((boolean)true);
            }
        }
    }

    protected boolean checkAnnotation(IFile javaFile) {
        return JavaDocumentUtils.hasWebServiceAnnotation(javaFile);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        LOG.debug((Object)("clean for the project:" + this.getProject().getName()));
        IContainer wsdlFolder = JaxWsWorkspaceManager.getWSDLFolder(this.getProject());
        if (wsdlFolder instanceof IFolder) {
            wsdlFolder.delete(true, monitor);
        } else if (wsdlFolder instanceof IProject) {
            IResource[] resources = ((IProject)wsdlFolder).members();
            int i = 0;
            while (i < resources.length) {
                if ("wsdl".equals(resources[i].getFileExtension())) {
                    resources[i].delete(true, monitor);
                }
                ++i;
            }
        }
        this.getProject().refreshLocal(2, null);
    }

    protected void removeResourceFile(IResource res) throws CoreException {
        if (!(res instanceof IFile)) {
            return;
        }
        IFile file = (IFile)res;
        if (!file.getFileExtension().equals("java")) {
            return;
        }
        if (this.checkAnnotation(file)) {
            LOG.debug((Object)("WebService java file has been removed:" + file.getFullPath()));
            String clsName = JDTUtils.getJavaClassNameFromFile((IFile)file);
            if (clsName.lastIndexOf(".") > 0) {
                clsName = clsName.substring(clsName.lastIndexOf("."));
            }
            String wsdlName = String.valueOf(clsName) + ".wsdl";
            LOG.debug((Object)("  need to remove:" + wsdlName));
            IContainer folder = JaxWsWorkspaceManager.getWSDLFolder(this.getProject());
            IResource wsdlResource = folder.findMember(wsdlName);
            if (wsdlResource.exists()) {
                LOG.debug((Object)("delete wsdl resource:" + wsdlResource.getFullPath()));
                wsdlResource.delete(1, null);
            }
        }
    }
}

