/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class ProjectWizardBase
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String GENERAL_PAGE = "generalPage";
    protected IConfigurationElement fConfigElement;
    WizardNewProjectCreationPage genPage;
    protected String projectMode;
    protected IProject project;

    public ProjectWizardBase() {
        String title = ScJaxWsResources.getString("CreateWebServiceProjectWizard.Title");
        this.setWindowTitle(title);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public void addPages() {
        this.genPage = new WizardNewProjectCreationPage(GENERAL_PAGE);
        this.genPage.setTitle(ScJaxWsResources.getString("WebServiceGeneralPage.Title"));
        this.genPage.setDescription(ScJaxWsResources.getString("WebServiceGeneralPage.Description"));
        ImageDescriptor banner = ScJaxWsResources.getImageDescriptor("wizban/Celtix_project_folder_wiz.jpg");
        this.genPage.setImageDescriptor(banner);
        this.addPage((IWizardPage)this.genPage);
    }

    public boolean performFinish() {
        try {
            this.createProject(null);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
    }

    protected boolean createProject(IProgressMonitor newMonitor) throws InvocationTargetException {
        IProgressMonitor checkedMonitor = newMonitor != null ? newMonitor : new NullProgressMonitor();
        checkedMonitor.beginTask("", 100);
        SubProgressMonitor createProjectMonitor = new SubProgressMonitor(checkedMonitor, 20);
        this.project = JaxWsWorkspaceManager.createProject((IProgressMonitor)createProjectMonitor, this.genPage.getProjectName(), this.genPage.getLocationPath(), this.projectMode);
        try {
            this.project.refreshLocal(2, checkedMonitor);
        }
        catch (Exception ce) {
            ce.printStackTrace();
        }
        return true;
    }

    public String getProjectMode() {
        return this.projectMode;
    }

    protected void setProjectMode(String value) {
        this.projectMode = value;
    }
}

