/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.validator.AnnotationValidator;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.stp.sc.common.wizards.AbstractScWizardPage;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.wizards.annotations.AttributeControlProxy;
import org.eclipse.stp.sc.jaxws.wizards.annotations.CreateAnnotationWizard;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAttributePage
extends AbstractScWizardPage {
    public static final String PAGE_NAME_PREFIX = "attributePage_";
    protected HashMap<String, AttributeControlProxy> attributeMap;
    protected CreateAnnotationWizard parentWizard;
    private String pageDesc;
    private Class<? extends Annotation> annotationHandled;
    private Button btnAnnSpecified;
    private Group grpAttrib;
    private boolean isAttributeEnabledByDefault;
    private static ImageDescriptor defaultAnnPageImgDesc = ScJaxWsResources.getImageDescriptor("wizban/newannotation_wiz.gif");

    public AnnotationAttributePage(CreateAnnotationWizard aParentWizard, String aPageDesc, String aHelpContextId, Class<? extends Annotation> anAnnotationHandled, boolean enabledByDefault) {
        super((AbstractScWizard)aParentWizard, AnnotationAttributePage.generatePageName(anAnnotationHandled), aHelpContextId);
        this.parentWizard = aParentWizard;
        this.attributeMap = new HashMap();
        this.pageDesc = aPageDesc;
        this.annotationHandled = anAnnotationHandled;
        this.isAttributeEnabledByDefault = enabledByDefault;
        this.setTitle(String.valueOf(ScJaxWsResources.getString("annotation.wizard.attribute.page.title.start")) + " " + this.annotationHandled.getSimpleName() + " " + ScJaxWsResources.getString("annotation.wizard.attribute.page.title.end"));
        if (this.pageDesc == null) {
            this.setDescription(String.valueOf(ScJaxWsResources.getString("annotation.wizard.attribute.page.desc.start")) + " " + this.annotationHandled.getSimpleName());
        } else {
            this.setDescription(this.pageDesc);
        }
        this.setImageDescriptor(defaultAnnPageImgDesc);
    }

    public static String generatePageName(Class<? extends Annotation> annClass) {
        return PAGE_NAME_PREFIX + annClass.getSimpleName();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.btnAnnSpecified = new Button(container, 32);
        this.btnAnnSpecified.setText(ScJaxWsResources.getString("annotation.wizard.attribute.page.chk.lbl"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.btnAnnSpecified.setLayoutData((Object)gridData);
        this.btnAnnSpecified.setSelection(this.isAttributeEnabledByDefault);
        this.btnAnnSpecified.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnnotationAttributePage.this.btnAnnSpecified.getSelection()) {
                    AnnotationAttributePage.this.initializeFromDefault();
                } else {
                    AnnotationAttributePage.this.clearValuesForAttributeControls();
                }
                AnnotationAttributePage.this.setAttribGoupEnabled(AnnotationAttributePage.this.btnAnnSpecified.getSelection());
            }
        });
        this.grpAttrib = this.createAttributeGroup(container, this.annotationHandled);
        this.setAttribGoupEnabled(this.isAttributeEnabledByDefault);
        this.setControl((Control)container);
    }

    protected Group createAttributeGroup(Composite container, Class<? extends Annotation> declaringClass) {
        Method[] methods = declaringClass.getDeclaredMethods();
        if (methods == null || methods.length <= 0) {
            return null;
        }
        Group grpAttrib = new Group(container, 0);
        grpAttrib.setText(ScJaxWsResources.getString("annotation.wizard.attribute.page.grp.lbl"));
        grpAttrib.setLayoutData((Object)new GridData(1808));
        grpAttrib.setLayout((Layout)new GridLayout(2, false));
        ArrayList<Method> methodList = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            int index = 0;
            while (index < methodList.size() && methods[i].getName().compareTo(((Method)methodList.get(index)).getName()) > 0) {
                ++index;
            }
            methodList.add(index, methods[i]);
            ++i;
        }
        String attribName = "";
        Label lbl = null;
        int i2 = 0;
        while (i2 < methodList.size()) {
            attribName = ((Method)methodList.get(i2)).getName();
            lbl = new Label((Composite)grpAttrib, 0);
            lbl.setText(attribName);
            AttributeControlProxy attribCtrl = AttributeControlProxy.createInstance(grpAttrib, attribName, ((Method)methodList.get(i2)).getReturnType(), (ModifyListener)new AbstractScWizardPage.UpdatePageStatusModifyListener((AbstractScWizardPage)this));
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            attribCtrl.getControl().setLayoutData((Object)gridData);
            this.attributeMap.put(attribName, attribCtrl);
            ++i2;
        }
        this.initializeFromDefault();
        return grpAttrib;
    }

    public void applyToData(Map<String, Object> data) throws Exception {
        List<MemberValuePair> annotValues = null;
        if (this.btnAnnSpecified.getSelection()) {
            annotValues = this.createAnnotationValues(this.parentWizard.getCuAstNodeFromData(), this.parentWizard.getJavaMemberFromData());
        }
        this.parentWizard.setAnnAttributesToData(CreateAnnotationWizard.getAttributesDataKey(this.annotationHandled), annotValues);
    }

    private void initializeFromDefault() {
        IMember member;
        CompilationUnit astRoot = this.parentWizard.getCuAstNodeFromData();
        org.eclipse.jdt.core.dom.Annotation ann = ScAnnotationSupportUtils.getDefaultedAnnotationNode(this.annotationHandled, (CompilationUnit)astRoot, (IMember)(member = this.parentWizard.getJavaMemberFromData()), null);
        if (ann != null) {
            List values = ((NormalAnnotation)ann).values();
            this.setValuesForAttributeControls(values);
        }
    }

    public void initializeFromData(Map<String, Object> data) throws Exception {
        NormalAnnotation annotation;
        List<MemberValuePair> annotValues = this.parentWizard.getAnnAttributesFromData(CreateAnnotationWizard.getAttributesDataKey(this.annotationHandled));
        CompilationUnit astRoot = this.parentWizard.getCuAstNodeFromData();
        if (annotValues != null) {
            this.btnAnnSpecified.setSelection(true);
            annotation = JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)this.annotationHandled.getSimpleName(), annotValues);
        } else {
            IMember member = this.parentWizard.getJavaMemberFromData();
            org.eclipse.jdt.core.dom.Annotation existAnnot = JDTUtils.findAnnotation((CompilationUnit)astRoot, (IMember)member, (org.eclipse.jdt.core.dom.Annotation)(annotation = ScAnnotationSupportUtils.getDefaultedAnnotationNode(this.annotationHandled, (CompilationUnit)astRoot, (IMember)member, null)));
            if (existAnnot != null) {
                annotation = existAnnot;
                this.btnAnnSpecified.setSelection(true);
            }
        }
        this.setValuesForAttributeControls(annotation.values());
    }

    protected void setValuesForAttributeControls(List<MemberValuePair> attributeValues) {
        for (MemberValuePair newValue : attributeValues) {
            AttributeControlProxy attrib = this.attributeMap.get(newValue.getName().toString());
            if (attrib == null) continue;
            attrib.setControlValue(newValue);
        }
    }

    protected void clearValuesForAttributeControls() {
        Iterator<AttributeControlProxy> iter = this.attributeMap.values().iterator();
        while (iter.hasNext()) {
            iter.next().clearControlValue();
        }
    }

    protected List<MemberValuePair> createAnnotationValues(CompilationUnit astRoot, IMember member) {
        ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
        Object newValue = null;
        for (AttributeControlProxy attrib : this.attributeMap.values()) {
            newValue = attrib.getControlValue();
            if (newValue == null) continue;
            MemberValuePair valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)attrib.getName(), (Object)newValue);
            annotValues.add(valPair);
        }
        return annotValues;
    }

    protected boolean validateInputs() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.btnAnnSpecified.getSelection()) {
            return true;
        }
        AnnotationValidator validator = new AnnotationValidator();
        NormalAnnotation annotationToAdd = JDTUtils.newNormalAnnotation((CompilationUnit)this.parentWizard.getCuAstNodeFromData(), (String)this.annotationHandled.getCanonicalName(), this.createAnnotationValues(this.parentWizard.getCuAstNodeFromData(), this.parentWizard.getJavaMemberFromData()));
        if (!validator.validateAnn(annotationToAdd)) {
            this.setErrorMessage(validator.getLastErrorMessage());
            return false;
        }
        return true;
    }

    public HashMap<String, AttributeControlProxy> getAttributeMap() {
        return this.attributeMap;
    }

    private void setAttribGoupEnabled(boolean isEnabled) {
        if (this.grpAttrib != null) {
            Control[] grpChildren = this.grpAttrib.getChildren();
            int i = 0;
            while (i < grpChildren.length) {
                grpChildren[i].setEnabled(isEnabled);
                ++i;
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

