/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.workspace;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.preferences.PreferencesAccessor;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;

public class ScNature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.stp.sc.jaxws.nature";
    public static final String JAVA_NATURE_ID = "org.eclipse.jdt.core.javanature";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScNature.class);
    private IProject theProject;
    private String runtimeProviderUID;
    private String projectMode = "JavaFrist";

    public void configure() throws CoreException {
        String mode = this.theProject.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
        if (mode == null || mode.equals("JavaFrist")) {
            this.configureJavaFirst();
        } else {
            this.configureWsdlFirst();
        }
    }

    private void configureJavaFirst() throws CoreException {
        WorkspaceManager.addBuilder((IProject)this.theProject, (String)"org.eclipse.stp.sc.annvalidator", (WorkspaceManager.BuilderOrder)WorkspaceManager.BuilderOrder.FIRST);
        LOG.debug((Object)"configure jaxws project with j2wsdl builder");
        WorkspaceManager.addBuilder((IProject)this.theProject, (String)"org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder", (WorkspaceManager.BuilderOrder)WorkspaceManager.BuilderOrder.LAST);
    }

    private void configureWsdlFirst() throws CoreException {
    }

    public void deconfigure() throws CoreException {
        LOG.debug((Object)"deconfigure jaxws project with j2wsdl builder");
        WorkspaceManager.removeBuilder((IProject)this.theProject, (String)"org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder");
        WorkspaceManager.removeBuilder((IProject)this.theProject, (String)"org.eclipse.stp.sc.annvalidator");
    }

    public IProject getProject() {
        return this.theProject;
    }

    public void setProject(IProject value) {
        this.theProject = value;
    }

    public static void addToProject(IProject project, String projectMode) throws CoreException {
        if (!project.hasNature(JAVA_NATURE_ID)) {
            MessageDialog.openWarning(null, (String)ScJaxWsResources.getString("ScNature.no.java.dialog.title"), (String)ScJaxWsResources.getString("ScNature.no.java.dialog.message"));
            return;
        }
        ScNature.addToProject(JavaCore.create((IProject)project), projectMode);
    }

    private static void initializeProjectProperties(IProject project, IRuntimeKitProcessor rtProcessor) {
        IPath kitPath = rtProcessor.getInstallationDirectory();
        try {
            project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT, kitPath.toOSString());
            if (PreferencesAccessor.getSoap12Option()) {
                project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION, "SOAP 1.2");
            } else {
                project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION, "SOAP 1.1");
            }
        }
        catch (CoreException e) {
            LOG.debug((Object)"Exception got in initializing project properties", (Throwable)e);
        }
    }

    public static void addToProject(IJavaProject jproject, String projectMode) throws CoreException {
        IProject project = jproject.getProject();
        if (!project.hasNature(NATURE_ID)) {
            String providerUID = RuntimeProviderManager.getInstance().pickAProvider();
            IRuntimeKitProcessor rtProcessor = ScJaxWsPlugin.getRuntimeProviderManager().getRuntimeKitProcessor(providerUID);
            if (!rtProcessor.isInstallationDirectoryValid(rtProcessor.getInstallationDirectory())) {
                MessageDialog.openWarning(null, (String)ScJaxWsResources.getString("JaxWs.Warning.Title"), (String)ScJaxWsResources.getString("JaxWs.Missing.Install.Text"));
                return;
            }
            project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE, projectMode);
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = NATURE_ID;
            desc.setNatureIds(ScNature.reorderNature(newNatures));
            project.setDescription(desc, null);
            ScNature theNature = new ScNature();
            theNature.setProject(project);
            theNature.setRuntimeProviderId(providerUID);
            theNature.setProjectMode(projectMode);
            ScNature.initializeProjectProperties(project, rtProcessor);
            LOG.debug((Object)"adding libraries to project");
            rtProcessor.completeJavaProjectBuildPath(jproject);
        }
    }

    private static String[] reorderNature(String[] natures) {
        ArrayList<String> natureList = new ArrayList<String>();
        int i = 0;
        while (i < natures.length) {
            natureList.add(natures[i]);
            ++i;
        }
        if (natureList.contains(JAVA_NATURE_ID)) {
            // empty if block
        }
        natureList.remove(NATURE_ID);
        natureList.add(natureList.indexOf(JAVA_NATURE_ID), NATURE_ID);
        String[] newNatures = new String[natureList.size()];
        int i2 = 0;
        while (i2 < natureList.size()) {
            newNatures[i2] = (String)natureList.get(i2);
            ++i2;
        }
        return newNatures;
    }

    public static void removeFromProject(IProject project) throws CoreException {
        if (project.hasNature(JAVA_NATURE_ID)) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            ScNature.removeFromProject(javaProject);
        }
    }

    public static void removeFromProject(IJavaProject jproject) throws CoreException {
        IProject project = jproject.getProject();
        ScJaxWsPlugin.getRuntimeProviderManager().getRuntimeKitProcessor(project).clearJavaProjectBuildPath(jproject);
        if (project.hasNature(NATURE_ID)) {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            ArrayList newNatures = new ArrayList(Arrays.asList(natures));
            newNatures.remove(newNatures.indexOf(NATURE_ID));
            desc.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
            project.setDescription(desc, null);
        }
    }

    public static boolean hasNature(IProject aProject) throws CoreException {
        return aProject.hasNature(NATURE_ID);
    }

    public String getRuntimeProviderUID() {
        if (this.runtimeProviderUID == null) {
            try {
                this.runtimeProviderUID = this.theProject.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_PROVIDER_UID);
            }
            catch (CoreException coreException) {
                this.runtimeProviderUID = null;
            }
        }
        return this.runtimeProviderUID;
    }

    public void setRuntimeProviderId(String aRuntimeProviderId) {
        this.runtimeProviderUID = aRuntimeProviderId;
        try {
            this.theProject.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_PROVIDER_UID, aRuntimeProviderId);
        }
        catch (CoreException coreException) {
            this.runtimeProviderUID = null;
        }
    }

    public String getProjectMode() {
        if (this.projectMode == null) {
            try {
                this.projectMode = this.theProject.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
            }
            catch (CoreException coreException) {
                this.projectMode = null;
            }
        }
        return this.projectMode;
    }

    public void setProjectMode(String mode) {
        this.projectMode = mode;
        try {
            this.theProject.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE, mode);
        }
        catch (CoreException coreException) {
            this.projectMode = null;
        }
    }
}

