/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.tomcat.cp;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.VersionProviderConnection;
import org.eclipse.stp.soas.deploy.tomcat.cp.TomcatConnectionFactory;

public class TomcatConnection
extends VersionProviderConnection
implements IConnection {
    public static String TOMCAT_WEBDIR = "webapps";
    private static String TOMCAT_DEPLOY_KEY = "catalina.deploy";
    File tomcatDir;
    Exception connectException;

    public TomcatConnection(IConnectionProfile profile) {
        super(profile, TomcatConnectionFactory.class);
        Properties props = profile.getBaseProperties();
        String deployDir = (String)props.get(TOMCAT_DEPLOY_KEY);
        if (deployDir != null && !deployDir.equals("")) {
            this.tomcatDir = new File(deployDir);
        } else {
            String dir = props.getProperty("dir");
            this.tomcatDir = new File(String.valueOf(dir) + File.separator + TOMCAT_WEBDIR);
        }
        if (this.tomcatDir.exists()) {
            this.updateVersionCache();
        } else {
            this.connectException = new IOException(this.tomcatDir + " does not exists");
            this.clearVersionCache();
        }
    }

    protected String getTechnologyRootKey() {
        return "TomcatContainer";
    }

    public void close() {
    }

    public Throwable getConnectException() {
        return this.connectException;
    }

    public Object getRawConnection() {
        return this.tomcatDir;
    }

    public String getProviderName() {
        return "Tomcat";
    }

    public Version getProviderVersion() {
        return Version.valueOf((String)"5.5");
    }

    public String getTechnologyName() {
        return "Servlet";
    }

    public Version getTechnologyVersion() {
        return Version.valueOf((String)"2.4");
    }
}

