/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.tomcat.wtp;

import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.stp.soas.deploy.core.adapters.IWTPServerAdapter;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;

public class WtpTomcatServerAdapter
implements IWTPServerAdapter {
    IServer wtpServer = null;
    String connectionProfileID = null;

    public void setProviderID(String provider) {
        this.connectionProfileID = provider;
    }

    public IConnectionProfile asConnectionProfile() {
        try {
            String profileName = this.wtpServer.getName();
            String profileDesc = this.wtpServer.getServerType().getDescription();
            String profileProviderID = this.connectionProfileID;
            ConnectionProfileProvider cfr_ignored_0 = (ConnectionProfileProvider)ConnectionProfileManager.getInstance().getProvider(profileProviderID);
            ConnectionProfile cp = new ConnectionProfile(profileName, profileDesc, profileProviderID);
            cp.setAutoConnect(false);
            Properties props = new Properties();
            Server svr = (Server)this.wtpServer;
            ILaunchConfiguration cfg = svr.getLaunchConfiguration(true, null);
            String deployDir = this.getDeployDir(cfg);
            if (deployDir != null) {
                props.setProperty("catalina.deploy", deployDir);
            }
            String installDir = this.getServerInstallDir(cfg);
            props.setProperty("dir", installDir);
            cp.setBaseProperties(props);
            return cp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setWtpServer(IServer server) {
        this.wtpServer = server;
    }

    private String getServerInstallDir(ILaunchConfiguration cfg) throws CoreException {
        return this.getAttrSegment(cfg, "org.eclipse.jdt.launching.VM_ARGUMENTS", "-Dcatalina.base=\"");
    }

    private String getDeployDir(ILaunchConfiguration cfg) throws CoreException {
        return this.getAttrSegment(cfg, "org.eclipse.jdt.launching.VM_ARGUMENTS", "-Dcatalina.deploy=\"");
    }

    private String getAttrSegment(ILaunchConfiguration cfg, String attrName, String segmentName) throws CoreException {
        String vmArgs = cfg.getAttribute(attrName, "");
        if (vmArgs == null || vmArgs.equals("")) {
            return null;
        }
        if (vmArgs.indexOf(segmentName) < 0) {
            return null;
        }
        String deployDir = vmArgs.substring(vmArgs.indexOf(segmentName) + segmentName.length());
        deployDir = deployDir.substring(0, deployDir.indexOf("\""));
        return deployDir;
    }
}

