/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrangeSelectionRecursivelyAction
extends DiagramAction {
    public static final String ID = "ArrangeSelectionRecursivelyAction";

    public ArrangeSelectionRecursivelyAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setId(ID);
        this.setText(BpmnDiagramMessages.ArrangeSelectionRecursivelyAction_arrangeSelection);
    }

    public ArrangeSelectionRecursivelyAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
        this.setId(ID);
        this.setText(BpmnDiagramMessages.ArrangeSelectionRecursivelyAction_arrangeSelection);
    }

    public Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    private void nodeRecursiveSearch(Map activities, List containers, View container, List onlyAccepted) {
        if (!containers.contains(container)) {
            containers.add(0, container);
        }
        if (activities.get(container) == null) {
            activities.put(container, new LinkedList());
        }
        for (Object view : container.getChildren()) {
            if (view instanceof Node) {
                if (((View)view).getElement() != null && ((View)view).getElement() instanceof Vertex && ((Vertex)((View)view).getElement()).getGraph() == null || onlyAccepted != null && !onlyAccepted.contains(view)) continue;
                ((List)activities.get(container)).add(view);
            }
            if (!(((View)view).getElement() instanceof Graph)) continue;
            this.nodeRecursiveSearch(activities, containers, (View)view, null);
        }
    }

    public Command getCommand() {
        if (this.getSelectedObjects().isEmpty()) {
            return null;
        }
        CompoundCommand compoundArrange = new CompoundCommand();
        HashMap activities = new HashMap();
        LinkedList containers = new LinkedList();
        LinkedList<View> onlyAccepted = new LinkedList<View>();
        HashSet<View> firstLevelContainers = new HashSet<View>();
        for (Object editPart : this.getSelectedObjects()) {
            if (editPart instanceof IGraphicalEditPart) {
                View v = ((IGraphicalEditPart)editPart).getNotationView();
                onlyAccepted.add(v);
                if (!(v.eContainer() instanceof View)) continue;
                firstLevelContainers.add((View)v.eContainer());
                continue;
            }
            return null;
        }
        for (View firstLevelContainer : firstLevelContainers) {
            if (firstLevelContainer == null) continue;
            this.nodeRecursiveSearch(activities, containers, firstLevelContainer, onlyAccepted);
        }
        if (((EditPart)this.getSelectedObjects().get(0)).getRoot() == null || ((EditPart)this.getSelectedObjects().get(0)).getRoot().getViewer() == null) {
            return null;
        }
        Map epRegistry = ((EditPart)this.getSelectedObjects().get(0)).getRoot().getViewer().getEditPartRegistry();
        for (Object container : containers) {
            ArrangeRequest arrangeRequest = new ArrangeRequest("arrangeSelectionAction");
            LinkedList editParts = new LinkedList();
            for (Object activity : (List)activities.get(container)) {
                Object ep = epRegistry.get(activity);
                if (ep instanceof Collection) {
                    editParts.addAll((Collection)ep);
                    continue;
                }
                if (ep == null) continue;
                editParts.add(ep);
            }
            if (editParts.isEmpty()) continue;
            arrangeRequest.setPartsToArrange(editParts);
            Command co = ((IGraphicalEditPart)editParts.get(0)).getCommand((Request)arrangeRequest);
            compoundArrange.add(co);
        }
        return compoundArrange;
    }

    public static void arrange(final List<? extends EditPart> editParts) {
        if (editParts.isEmpty()) {
            return;
        }
        IWorkbenchPage page = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        } else if (PlatformUI.getWorkbench().getWorkbenchWindowCount() != 0) {
            page = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
        }
        if (page == null) {
            throw new IllegalArgumentException(BpmnDiagramMessages.ArrangeSelectionRecursivelyAction_no_page_to_initialize);
        }
        ArrangeSelectionRecursivelyAction action = new ArrangeSelectionRecursivelyAction(page){

            protected List getSelectedObjects() {
                return editParts;
            }
        };
        IGraphicalEditPart gmfEditPart = null;
        for (EditPart editPart : editParts) {
            if (!(editPart instanceof IGraphicalEditPart)) continue;
            gmfEditPart = (IGraphicalEditPart)editPart;
            break;
        }
        if (gmfEditPart == null) {
            for (Object object : editParts.get(0).getChildren()) {
                if (!(object instanceof IGraphicalEditPart)) continue;
                gmfEditPart = (IGraphicalEditPart)object;
                break;
            }
        }
        if (gmfEditPart == null) {
            throw new IllegalArgumentException(BpmnDiagramMessages.ArrangeSelectionRecursivelyAction_no_part_available);
        }
        gmfEditPart.getDiagramEditDomain().getDiagramCommandStack().execute(action.getCommand());
    }
}

