/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.actions.GroupAction;
import org.eclipse.stp.bpmn.diagram.actions.UngroupAction;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupInSubprocessCommand
extends AbstractTransactionalCommand {
    String _createdSubprocessProxyId;
    private String _originalContainerProxyId;
    private IDiagramGraphicalViewer viewer;
    private Map<String, Class> selectedEps = new HashMap<String, Class>();
    private Set<GraphicalEditPart> editParts;
    private List<IGraphicalEditPart> almostSelectedBoundaryEvents = new ArrayList<IGraphicalEditPart>();
    private Collection<SequenceEdgeEditPart> externalSrcConnections = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> externalTgtConnections = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> internalConnections = new HashSet<SequenceEdgeEditPart>();

    public GroupInSubprocessCommand(TransactionalEditingDomain domain, Set<GraphicalEditPart> editParts, List<IGraphicalEditPart> almostSelectedBoundaryEvents, Collection<SequenceEdgeEditPart> externalSrcConnections, Collection<SequenceEdgeEditPart> externalTgtConnections, Collection<SequenceEdgeEditPart> internalConnections) {
        super(domain, BpmnDiagramMessages.GroupInSubprocessCommand_label, null);
        this.editParts = editParts;
        this.almostSelectedBoundaryEvents = almostSelectedBoundaryEvents;
        this.externalSrcConnections = externalSrcConnections;
        this.externalTgtConnections = externalTgtConnections;
        this.internalConnections = internalConnections;
    }

    public GroupInSubprocessCommand(TransactionalEditingDomain domain, IDiagramGraphicalViewer viewer, Map<String, Class> contentToGroup, String originalContainerProxyId) {
        super(domain, BpmnDiagramMessages.GroupInSubprocessCommand_label, null);
        this.editParts = new HashSet<GraphicalEditPart>();
        this.almostSelectedBoundaryEvents = new ArrayList<IGraphicalEditPart>();
        this.externalSrcConnections = new ArrayList<SequenceEdgeEditPart>();
        this.externalTgtConnections = new ArrayList<SequenceEdgeEditPart>();
        this.internalConnections = new ArrayList<SequenceEdgeEditPart>();
        this.viewer = viewer;
        this.selectedEps = contentToGroup;
        this._originalContainerProxyId = originalContainerProxyId;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) {
        Object act;
        SequenceEdge edge;
        EditPart tmpContainerEditPart = null;
        if (this.viewer == null) {
            tmpContainerEditPart = this.editParts.iterator().next().getParent();
            this._originalContainerProxyId = EMFCoreUtil.getProxyID((EObject)((GraphicalEditPart)tmpContainerEditPart).resolveSemanticElement());
            this.viewer = (IDiagramGraphicalViewer)tmpContainerEditPart.getViewer();
            for (GraphicalEditPart ep : this.editParts) {
                this.selectedEps.put(EMFCoreUtil.getProxyID((EObject)ep.resolveSemanticElement()), ep.getClass());
            }
        } else {
            List eps = this.viewer.findEditPartsForElement(this._originalContainerProxyId, ShapeCompartmentEditPart.class);
            if (eps.isEmpty()) {
                return null;
            }
            tmpContainerEditPart = (EditPart)eps.get(0);
            ArrayList newSel = new ArrayList();
            for (Map.Entry<String, Class> entry : this.selectedEps.entrySet()) {
                eps = this.viewer.findEditPartsForElement(entry.getKey(), entry.getValue());
                if (eps.isEmpty()) continue;
                newSel.addAll(eps);
            }
            GroupAction.refresh(null, (IStructuredSelection)new StructuredSelection(newSel), this.editParts, this.almostSelectedBoundaryEvents, this.externalSrcConnections, this.externalTgtConnections, this.internalConnections);
        }
        EditPart containerEditPart = tmpContainerEditPart;
        CreateViewRequest req = CreateViewRequestFactory.getCreateShapeRequest((IElementType)BpmnElementTypes.SubProcess_2002, (PreferencesHint)BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        for (Map.Entry<String, Class<Object>> desc : req.getViewDescriptors()) {
            CreateElementRequest createSubProcessSemanticRequest = (CreateElementRequest)((CreateViewRequest.ViewDescriptor)desc).getElementAdapter().getAdapter(CreateElementRequest.class);
            createSubProcessSemanticRequest.setParameter("createChild", (Object)Boolean.FALSE);
        }
        Rectangle rect = this.getSizeAndLocation(req);
        Command create = containerEditPart.getCommand((Request)req);
        create.execute();
        Node spview = (Node)((IAdaptable)((List)req.getNewObject()).get(0)).getAdapter(Node.class);
        this._createdSubprocessProxyId = EMFCoreUtil.getProxyID((EObject)spview.getElement());
        LinkedList<EObject> semantic = new LinkedList<EObject>();
        for (GraphicalEditPart graphicalEditPart : this.editParts) {
            semantic.add(graphicalEditPart.resolveSemanticElement());
            if (!(graphicalEditPart.resolveSemanticElement() instanceof Activity)) continue;
            Graph graph = ((Activity)graphicalEditPart.resolveSemanticElement()).getGraph();
            graph.getVertices().remove((Object)graphicalEditPart.resolveSemanticElement());
            ((Activity)graphicalEditPart.resolveSemanticElement()).setGraph(null);
        }
        for (SequenceEdgeEditPart sequenceEdgeEditPart : this.externalSrcConnections) {
            edge = (SequenceEdge)sequenceEdgeEditPart.resolveSemanticElement();
            edge.setSource((Vertex)spview.getElement());
            ((Edge)sequenceEdgeEditPart.getNotationView()).setSource((View)spview);
        }
        for (SequenceEdgeEditPart sequenceEdgeEditPart : this.externalTgtConnections) {
            edge = (SequenceEdge)sequenceEdgeEditPart.resolveSemanticElement();
            edge.setTarget((Vertex)spview.getElement());
            ((Edge)sequenceEdgeEditPart.getNotationView()).setTarget((View)spview);
        }
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(rect.x);
        bounds.setY(rect.y);
        bounds.setHeight(rect.height);
        bounds.setWidth(rect.width);
        spview.setLayoutConstraint((LayoutConstraint)bounds);
        View compartmentView = null;
        String compartmentId = Integer.toString(5002);
        for (Object spchild : spview.getChildren()) {
            View vchild = (View)spchild;
            if (!compartmentId.equals(vchild.getType())) continue;
            compartmentView = vchild;
            break;
        }
        Location sploc = (Location)spview.getLayoutConstraint();
        for (GraphicalEditPart part : this.editParts) {
            View v = (View)part.getModel();
            compartmentView.insertChild(v);
            if (!(v instanceof Node)) continue;
            Bounds constraint = (Bounds)((Node)v).getLayoutConstraint();
            if (constraint != null) {
                if (constraint.getX() > 0) {
                    constraint.setX(constraint.getX() - sploc.getX());
                    if (constraint.getX() < 0) {
                        constraint.setX(0);
                    }
                }
                if (constraint.getY() <= 0) continue;
                constraint.setY(constraint.getY() - sploc.getY());
                if (constraint.getY() >= 0) continue;
                constraint.setY(0);
                continue;
            }
            ((Node)v).setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        }
        HashMap incoming = new HashMap();
        HashMap outgoing = new HashMap();
        for (EObject obj : semantic) {
            if (!(obj instanceof Activity)) continue;
            act = (Activity)obj;
            incoming.put((Activity)act, new ArrayList(act.getIncomingEdges()));
            outgoing.put((Activity)act, new ArrayList(act.getOutgoingEdges()));
            act.getIncomingEdges().clear();
            act.getOutgoingEdges().clear();
        }
        for (SequenceEdgeEditPart part : this.internalConnections) {
            SequenceEdge edge2 = (SequenceEdge)part.resolveSemanticElement();
            ((Graph)spview.getElement()).getSequenceEdges().add((Object)edge2);
        }
        for (EObject obj : semantic) {
            if (obj instanceof Activity) continue;
            if (obj instanceof Artifact) {
                ((SubProcess)spview.getElement()).getArtifacts().add((Object)((Artifact)obj));
                continue;
            }
            spview.getElement().eContents().add((Object)obj);
        }
        for (EObject obj : semantic) {
            if (!(obj instanceof Activity)) continue;
            ((Activity)obj).setGraph((Graph)spview.getElement());
        }
        for (EObject obj : semantic) {
            if (!(obj instanceof Activity)) continue;
            act = (Activity)obj;
            act.getIncomingEdges().addAll((Collection)incoming.get(act));
            act.getOutgoingEdges().addAll((Collection)outgoing.get(act));
        }
        Command command = containerEditPart.getCommand(new Request((Object)"refresh"));
        command.execute();
        for (SequenceEdgeEditPart part : this.externalSrcConnections) {
            part.refresh();
            part.activate();
        }
        for (SequenceEdgeEditPart part : this.externalTgtConnections) {
            part.refresh();
            part.activate();
        }
        for (GraphicalEditPart p : this.editParts) {
            for (Object connection : p.getTargetConnections()) {
                ((EditPart)connection).refresh();
                ((EditPart)connection).activate();
            }
            for (Object connection : p.getSourceConnections()) {
                ((EditPart)connection).refresh();
                ((EditPart)connection).activate();
            }
        }
        if (containerEditPart.getParent() instanceof PoolEditPart) {
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize children");
            request.setEditParts(containerEditPart.getChildren());
            request.setMoveDelta(new Point(0, 0));
            request.setSizeDelta(new Dimension(0, 0));
            Command co = containerEditPart.getCommand((Request)request);
            if (co != null && co.canExecute()) {
                co.execute();
            }
        } else {
            int height = rect.y + rect.height + 10;
            int width = rect.x + rect.width + 10;
            View parentView = (View)containerEditPart.getParent().getModel();
            if (((Bounds)((Node)parentView).getLayoutConstraint()).getHeight() < height) {
                ((Bounds)((Node)parentView).getLayoutConstraint()).setHeight(height);
            }
            if (((Bounds)((Node)parentView).getLayoutConstraint()).getWidth() < width) {
                ((Bounds)((Node)parentView).getLayoutConstraint()).setWidth(width);
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this._createdSubprocessProxyId == null) {
            return Status.CANCEL_STATUS;
        }
        if (this.viewer == null) {
            return Status.CANCEL_STATUS;
        }
        List eps = this.viewer.findEditPartsForElement(this._createdSubprocessProxyId, SubProcessEditPart.class);
        if (!eps.isEmpty()) {
            SubProcessEditPart spEditPart = (SubProcessEditPart)((Object)eps.get(0));
            UngroupAction.executeUngroupCommand(spEditPart);
            this._createdSubprocessProxyId = null;
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.doExecuteWithResult(monitor, info);
        return Status.OK_STATUS;
    }

    private Rectangle getSizeAndLocation(CreateViewRequest req) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        boolean firstTime = true;
        for (GraphicalEditPart part : this.editParts) {
            int Y;
            int X;
            int h;
            if (!(part.getNotationView() instanceof Node)) continue;
            LayoutConstraint constraint = ((Node)part.getNotationView()).getLayoutConstraint();
            if (constraint instanceof Location) {
                Location loc = (Location)constraint;
                int X2 = loc.getX();
                int Y2 = loc.getY();
                if (X2 != -1 && Y2 != -1) {
                    if (firstTime) {
                        firstTime = false;
                        x = X2;
                        y = Y2;
                    } else {
                        x = Math.min(X2, x);
                        y = Math.min(Y2, y);
                    }
                }
            }
            if (!(constraint instanceof Bounds)) continue;
            Bounds bounds = (Bounds)constraint;
            int w = bounds.getWidth();
            if (w == -1) {
                w = part.getFigure().getBounds().width;
            }
            if ((h = bounds.getHeight()) == -1) {
                h = part.getFigure().getBounds().height;
            }
            if ((X = bounds.getX()) == -1) {
                X = part.getFigure().getBounds().x;
            }
            if ((Y = bounds.getY()) == -1) {
                Y = part.getFigure().getBounds().y;
            }
            width = Math.max(width, w + X);
            height = Math.max(height, h + Y);
        }
        width -= x;
        height -= y;
        height += 25;
        height += SubProcessEditPart.INSETS.getHeight();
        width += SubProcessEditPart.INSETS.getWidth();
        Point pt = new Point(x, y);
        return new Rectangle(pt, new Dimension(width += 10, height += 10));
    }
}

