/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.stp.bpmn.validation.ConstraintStatusEx;
import org.eclipse.stp.bpmn.validation.IConstraintStatusEx;
import org.eclipse.stp.bpmn.validation.IResourceImportersRegistry;
import org.eclipse.stp.bpmn.validation.IValidationMarkerCreationHook;
import org.eclipse.stp.bpmn.validation.builder.BatchValidationBuilder;
import org.eclipse.stp.bpmn.validation.builder.ResourceImportersRegistry;
import org.eclipse.stp.bpmn.validation.builder.ValidationMarkerCustomAttributes;
import org.eclipse.stp.bpmn.validation.internal.InternalHelper;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnValidationPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.stp.bpmn.validation";
    public static final String BATCH_VALIDATION_BUILD_ABLE_NATURE_ID = "org.eclipse.stp.bpmn.validation.BatchValidationBuildAbleNature";
    public static final String GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID = BatchValidationBuilder.GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID;
    public static final String CREATION_MARKER_HOOK_EXTENSION_POINT = "org.eclipse.stp.bpmn.validation.ValidationMarkerCreationHook";
    private static BpmnValidationPlugin plugin;
    private static WeakHashMap<IProject, Map<String, IResourceImportersRegistry>> CACHE;
    private ISaveParticipant _saveParticipant;
    private Set<IValidationMarkerCreationHook> _creationMarkerCallBacks;

    static {
        CACHE = null;
    }

    public static Map<String, Object> createMarkerAttributesMap(Diagnostic diagnostic) {
        return ValidationMarkerCustomAttributes.createMarkerAttributesMap(diagnostic);
    }

    public static IConstraintStatusEx asConstraintStatusEx(IStatus st, String bpmnQuickfixResolutionID) {
        IConstraintStatusEx cons = null;
        if (st instanceof IConstraintStatusEx) {
            cons = (IConstraintStatusEx)st;
        } else if (st instanceof IConstraintStatus) {
            cons = new ConstraintStatusEx((IConstraintStatus)st);
        } else {
            return null;
        }
        if (bpmnQuickfixResolutionID != null) {
            cons.addMarkerAttribute("bpmnquickfixable", Boolean.TRUE.toString());
            cons.addMarkerAttribute("BPMN_QUICK_FIX_RESOLUTION_ID", bpmnQuickfixResolutionID);
        }
        return cons;
    }

    public static IConstraintStatusEx createFailureStatus(IValidationContext ctxt, EObject target, Object[] messageArguments) {
        IStatus st = ctxt.createFailureStatus(messageArguments);
        IConstraintStatusEx cons = BpmnValidationPlugin.asConstraintStatusEx(st, null);
        if (target != null) {
            ((ConstraintStatusEx)cons).setTarget(target);
        }
        return cons;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        CACHE = new WeakHashMap();
        this._saveParticipant = new ISaveParticipant(){

            public void doneSaving(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void rollback(ISaveContext context) {
            }

            public void saving(ISaveContext context) throws CoreException {
                IProject[] projects;
                IProject[] iProjectArray;
                if (context.getProject() == null) {
                    iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                } else {
                    IProject[] iProjectArray2 = new IProject[1];
                    iProjectArray = iProjectArray2;
                    iProjectArray2[0] = context.getProject();
                }
                IProject[] iProjectArray3 = projects = iProjectArray;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject proj = iProjectArray3[n2];
                    BpmnValidationPlugin.this.saveImportersRegistries(proj);
                    ++n2;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, this._saveParticipant);
        if (PlatformUI.isWorkbenchRunning()) {
            InternalHelper.loadAndDisposeUIModificationValidator();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        CACHE = null;
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
        super.stop(context);
    }

    public void saveImportersRegistries(IProject proj) {
        if (!proj.isAccessible()) {
            return;
        }
        Map<String, IResourceImportersRegistry> importIndexes = CACHE.get(proj);
        if (importIndexes != null) {
            for (Map.Entry<String, IResourceImportersRegistry> entry : importIndexes.entrySet()) {
                if (!entry.getValue().isDirty()) continue;
                try {
                    entry.getValue().save(proj, entry.getKey(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    this.getLog().log(e.getStatus());
                }
            }
        }
    }

    public static BpmnValidationPlugin getDefault() {
        return plugin;
    }

    public static synchronized IResourceImportersRegistry getResourceImportersRegistry(IProject project, String importersCategoryID, IProgressMonitor monitor) {
        IResourceImportersRegistry res;
        if (CACHE == null) {
            return null;
        }
        Map<String, IResourceImportersRegistry> importIndexes = CACHE.get(project);
        if (importIndexes == null) {
            importIndexes = new HashMap<String, IResourceImportersRegistry>();
            CACHE.put(project, importIndexes);
        }
        if ((res = importIndexes.get(importersCategoryID)) != null) {
            return res;
        }
        res = new ResourceImportersRegistry();
        res.load(project, importersCategoryID, monitor);
        importIndexes.put(importersCategoryID, res);
        return res;
    }

    public Collection<IValidationMarkerCreationHook> getCreationMarkerCallBacks() {
        if (this._creationMarkerCallBacks == null) {
            this._creationMarkerCallBacks = new HashSet<IValidationMarkerCreationHook>();
            IConfigurationElement[] configElems = Platform.getExtensionRegistry().getConfigurationElementsFor(CREATION_MARKER_HOOK_EXTENSION_POINT);
            int j = configElems.length - 1;
            while (j >= 0) {
                try {
                    IConfigurationElement el = configElems[j];
                    this._creationMarkerCallBacks.add((IValidationMarkerCreationHook)el.createExecutableExtension("class"));
                }
                catch (Exception e) {
                    this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, e.getMessage(), (Throwable)e));
                }
                --j;
            }
        }
        return this._creationMarkerCallBacks;
    }
}

