/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.ValidationObjectID;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BaseValidationObject
implements IValidationObject {
    private static DocumentBuilder documentBuilder = null;
    private Map props = new HashMap();
    private InputStream inputStream = null;
    private File fFile = null;
    private Document document = null;
    private ValidationObjectID id = null;
    private String sString = null;

    public BaseValidationObject(ValidationObjectID objID, InputStream is) {
        this.inputStream = is;
        this.id = objID;
    }

    public BaseValidationObject(ValidationObjectID objID, String string) {
        this.id = objID;
        this.sString = string;
    }

    public BaseValidationObject(ValidationObjectID objID, File file) {
        this.fFile = file;
        this.id = objID;
    }

    public BaseValidationObject(ValidationObjectID objID, Document doc) {
        this.document = doc;
        this.id = objID;
    }

    public ValidationObjectID getID() {
        return this.id;
    }

    public static ValidationObjectTypeEnum resolveObjectTypeFromFileName(String fileName) {
        return ValidationObjectTypeEnum.lookup(fileName.substring(fileName.lastIndexOf(46) + 1));
    }

    public Document getInput() throws ContextInitializationException {
        if (this.document == null) {
            if (documentBuilder == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                try {
                    documentBuilder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new ContextInitializationException("Could not instantiate DOM Document Builder: " + e.getMessage(), e);
                }
            }
            try {
                if (this.fFile != null) {
                    this.document = documentBuilder.parse(new FileInputStream(this.fFile));
                } else if (this.inputStream != null) {
                    this.document = documentBuilder.parse(this.inputStream);
                } else if (this.sString != null) {
                    this.document = documentBuilder.parse(new InputSource(new StringReader(this.sString)));
                }
            }
            catch (SAXException e) {
                throw new ContextInitializationException("XML Parser is not able to reparse the document content: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ContextInitializationException("The document content cannot be loaded: " + e.getMessage(), e);
            }
        }
        return this.document;
    }

    public Object getProperty(String propName) {
        return this.props.get(propName);
    }

    public void setProperty(String propName, Object propObj) {
        this.props.put(propName, propObj);
    }
}

