/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.sca.transform;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stp.im.ImFactory;
import org.eclipse.stp.im.Process;
import org.eclipse.stp.im.ProcessCollection;
import org.eclipse.stp.im.Service;
import org.eclipse.stp.im.ServiceCollection;
import org.eclipse.stp.im.Step;
import org.eclipse.stp.im.StpIntermediateModel;

public class IMHandler {
    private StpIntermediateModel stpIM = null;
    private ProcessCollection processCollection;
    private ServiceCollection serviceCollection;
    private ImFactory imFactory;

    public IMHandler() {
        this.imFactory = ImFactory.eINSTANCE;
        this.stpIM = this.imFactory.createStpIntermediateModel();
        this.processCollection = this.imFactory.createProcessCollection();
        this.serviceCollection = this.imFactory.createServiceCollection();
        this.stpIM.setProcessCollection(this.processCollection);
        this.stpIM.setServiceCollection(this.serviceCollection);
    }

    public IMHandler(URI uri) {
    }

    public StpIntermediateModel getStpIM() {
        return this.stpIM;
    }

    public Process createProcess(String name) {
        Process p = this.imFactory.createProcess();
        p.setName(name);
        this.processCollection.getProcesses().add((Object)p);
        return p;
    }

    public Service createService(String name) {
        Service s = this.imFactory.createService();
        s.setServiceName(name);
        this.serviceCollection.getServices().add((Object)s);
        return s;
    }

    public Step createStep(String stepName, Process parent) {
        Step s = this.imFactory.createStep();
        s.setName(stepName);
        parent.getSteps().add((Object)s);
        return s;
    }

    public void persistIM(URI uri) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(uri);
        resource.getContents().add((Object)this.stpIM);
        resource.save(Collections.EMPTY_MAP);
    }
}

