/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.wizards;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.policy.wtp.common.utils.ui.EclipseUI;
import org.eclipse.stp.policy.wtp.common.utils.ui.ParameterValidator;
import org.eclipse.stp.policy.wtp.editor.Messages;
import org.eclipse.stp.policy.wtp.validation.ui.SchemaEntityDecl;
import org.eclipse.stp.policy.wtp.validation.ui.UIControlValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OperationPolicyWizardPage
extends WizardPage {
    private Text _containerText = null;
    private Text _fileText;
    private Text _nameText;
    private Text _idText;
    private UIControlValidator _uiValidator = new UIControlValidator();

    public OperationPolicyWizardPage(ISelection selection) {
        super("wizardPage");
        this.setDescription(Messages.OperationPolicyNewWizard_MESSAGE_WIZARD_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OperationPolicyWizardPage.this.dialogChanged();
            }
        };
        this._containerText = EclipseUI.createDirectoryPath((Composite)container, (boolean)true);
        this._containerText.addModifyListener(modifyListener);
        Label label = new Label(container, 0);
        label.setText(Messages.WizardPage_LABEL_FILENAME);
        this._fileText = new Text(container, 2052);
        this._fileText.setText("ExampleService.opdx");
        this._fileText.setLayoutData((Object)new GridData(768));
        this._fileText.addModifyListener(modifyListener);
        label = new Label(container, 0);
        label.setText(Messages.OperationPolicyWizardPage_LABEL_ID);
        this._idText = new Text(container, 2052);
        this._idText.setLayoutData((Object)new GridData(768));
        this._idText.addModifyListener(modifyListener);
        label = new Label(container, 0);
        label.setText(Messages.OperationPolicyWizardPage_LABEL_NAME);
        this._nameText = new Text(container, 2052);
        this._nameText.setLayoutData((Object)new GridData(768));
        this._nameText.addModifyListener(modifyListener);
        this._uiValidator.addControl((Control)this._idText, new SchemaEntityDecl(2, "http://www.w3.org/2001/XMLSchema", "anyURI"));
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void dialogChanged() {
        String errMsg = null;
        errMsg = ParameterValidator.validateTargetFile((String)this.getContainerName(), (String)this.getFileName(), (String)"opdx");
        if (errMsg != null) {
            this.updateStatus(errMsg);
            return;
        }
        if (this._idText.getText().length() == 0) {
            this.updateStatus(Messages.OperationPolicyWizardPage_ERROR_ID_MUST_BE_SPECIFIED);
            return;
        }
        errMsg = this._uiValidator.validate((Control)this._idText, this._idText.getText());
        if (errMsg != null) {
            this.updateStatus("ID is invalid:" + errMsg);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this._containerText.getText();
    }

    public String getFileName() {
        return this._fileText.getText();
    }

    public String getPolicyName() {
        return this._nameText.getText();
    }

    public String getIdName() {
        return this._idText.getText();
    }
}

