/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.jdt.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.sca.common.jdt.builder.ScaDependencyVertex;
import org.eclipse.stp.sca.common.jdt.builder.ScaTnsNameCouple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaDependencyGraph {
    private Map<IFile, ScaDependencyVertex> registry = new HashMap<IFile, ScaDependencyVertex>();

    public void loadVertex(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException("The argument cannot be null.");
        }
        ScaDependencyVertex vertex = new ScaDependencyVertex(file);
        this.registry.put(file, vertex);
    }

    public void removeVertex(IFile file) {
        this.registry.remove(file);
    }

    public void clearVertices() {
        this.registry.clear();
    }

    public List<ScaDependencyVertex> findFilesWithSameIds() {
        HashMap<ScaTnsNameCouple, ArrayList<ScaDependencyVertex>> base = new HashMap<ScaTnsNameCouple, ArrayList<ScaDependencyVertex>>();
        for (Map.Entry<IFile, ScaDependencyVertex> entry : this.registry.entrySet()) {
            if (!entry.getValue().isValidEmfFile()) continue;
            ScaTnsNameCouple tnsNameCouple = entry.getValue().getTnsNameCouple();
            ArrayList<ScaDependencyVertex> files = (ArrayList<ScaDependencyVertex>)base.get(tnsNameCouple);
            if (files == null) {
                files = new ArrayList<ScaDependencyVertex>();
            }
            files.add(entry.getValue());
            base.put(tnsNameCouple, files);
        }
        ArrayList<ScaDependencyVertex> result = new ArrayList<ScaDependencyVertex>();
        for (List vertices : base.values()) {
            if (vertices.size() <= 1) continue;
            result.addAll(vertices);
        }
        return result;
    }

    public List<ScaDependencyVertex> findFilesWithWrongName() {
        ArrayList<ScaDependencyVertex> result = new ArrayList<ScaDependencyVertex>();
        for (ScaDependencyVertex vertex : this.registry.values()) {
            if (!vertex.isValidEmfFile()) continue;
            String compositeName = vertex.getTnsNameCouple().name;
            if (vertex.getFile().getName().equals(String.valueOf(compositeName) + ".composite")) continue;
            result.add(vertex);
        }
        return result;
    }

    public List<ScaDependencyVertex> findFilesEmfCouldNotLoad() {
        ArrayList<ScaDependencyVertex> result = new ArrayList<ScaDependencyVertex>();
        for (ScaDependencyVertex vertex : this.registry.values()) {
            if (vertex.isValidEmfFile()) continue;
            result.add(vertex);
        }
        return result;
    }

    public List<ScaDependencyVertex> getFilesToValidateWithEmf() {
        HashMap<IFile, Boolean> references = new HashMap<IFile, Boolean>();
        for (IFile file : this.registry.keySet()) {
            if (!this.registry.get(file).isValidEmfFile()) continue;
            references.put(file, false);
        }
        for (ScaDependencyVertex vertex : this.registry.values()) {
            if (!vertex.isValidEmfFile()) continue;
            for (ScaTnsNameCouple tnsNameCouple : vertex.getIncludes()) {
                ScaDependencyVertex v = this.getVertex(tnsNameCouple);
                if (v == null) continue;
                references.put(v.getFile(), true);
            }
        }
        ArrayList<ScaDependencyVertex> result = new ArrayList<ScaDependencyVertex>();
        for (Map.Entry entry : references.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            result.add(this.registry.get(entry.getKey()));
        }
        return result;
    }

    private ScaDependencyVertex getVertex(ScaTnsNameCouple tnsNameCouple) {
        for (ScaDependencyVertex vertex : this.registry.values()) {
            if (!vertex.getTnsNameCouple().equals(tnsNameCouple)) continue;
            return vertex;
        }
        return null;
    }

    public Map<ScaDependencyVertex, String> findDependencyCycles() {
        HashMap<ScaDependencyVertex, String> result = new HashMap<ScaDependencyVertex, String>();
        for (Map.Entry<IFile, ScaDependencyVertex> entry : this.registry.entrySet()) {
            String cycleDetails;
            if (!entry.getValue().isValidEmfFile() || (cycleDetails = this.checkDependency(entry.getValue(), new ArrayList<ScaDependencyVertex>())) == null) continue;
            result.put(entry.getValue(), cycleDetails);
        }
        return result;
    }

    private String checkDependency(ScaDependencyVertex vertex, Collection<ScaDependencyVertex> alreadyFoundDependencies) {
        alreadyFoundDependencies.add(vertex);
        ArrayList<ScaDependencyVertex> includes = new ArrayList<ScaDependencyVertex>();
        for (ScaTnsNameCouple tnsNameCouple : vertex.getIncludes()) {
            ScaDependencyVertex v = this.getVertex(tnsNameCouple);
            if (v == null) continue;
            includes.add(v);
        }
        for (ScaDependencyVertex v : includes) {
            if (alreadyFoundDependencies.contains(v)) {
                return String.valueOf(v.getFile().getName()) + " -> " + vertex.getFile().getName() + " -> " + v.getFile().getName();
            }
            alreadyFoundDependencies.add(v);
            String subDependencies = this.checkDependency(v, new ArrayList<ScaDependencyVertex>(alreadyFoundDependencies));
            if (subDependencies == null) continue;
            return subDependencies;
        }
        return null;
    }
}

