/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.jdt.builder.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.JavaImplementation;
import org.eclipse.stp.sca.JavaInterface;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.Wire;
import org.eclipse.stp.sca.common.jdt.Messages;
import org.eclipse.stp.sca.common.jdt.builder.extensions.IScaBuilderExtension;
import org.eclipse.stp.sca.common.jdt.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaBuilderJavaExtension
implements IScaBuilderExtension<IJavaProject> {
    @Override
    public List<Diagnostic> validate(DocumentRoot documentRoot, IJavaProject javaProject) {
        List<JavaRelationBean> beans = this.buildJavaRelations(documentRoot, javaProject);
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        for (JavaRelationBean bean : beans) {
            try {
                result.addAll(bean.validate(javaProject));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private List<JavaRelationBean> buildJavaRelations(DocumentRoot documentRoot, IJavaProject javaProject) {
        JavaRelationBean b;
        Composite c = documentRoot.getComposite();
        if (c == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaRelationBean> beans = new ArrayList<JavaRelationBean>();
        for (Service s : c.getService()) {
            if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
            b = new JavaCompositeElement();
            b.interfaceName = ((JavaInterface)s.getInterface()).getInterface();
            b.eo = s.getInterface();
            b.promotedElement = s.getPromote();
            if (s.getPromote2() != null && s.getPromote2().getInterface() != null && s.getPromote2().getInterface() instanceof JavaInterface) {
                b.promotedInterface = ((JavaInterface)s.getPromote2().getInterface()).getInterface();
            }
            beans.add(b);
        }
        for (Wire w : c.getWire()) {
            b = new JavaWireElement();
            if (w.getSource2() != null && w.getSource2().getInterface() != null && w.getSource2().getInterface() instanceof JavaInterface) {
                ((JavaWireElement)b).sourceInterface = ((JavaInterface)w.getSource2().getInterface()).getInterface();
                ((JavaWireElement)b).reference = w.getSource();
                ((JavaWireElement)b).eo = w.getSource2();
            }
            if (w.getTarget2() != null && w.getTarget2().getInterface() != null && w.getTarget2().getInterface() instanceof JavaInterface) {
                ((JavaWireElement)b).targetInterface = ((JavaInterface)w.getTarget2().getInterface()).getInterface();
                ((JavaWireElement)b).service = w.getTarget();
                ((JavaWireElement)b).eo = w.getTarget2();
            }
            if (((JavaWireElement)b).targetInterface == null || ((JavaWireElement)b).sourceInterface == null) continue;
            beans.add(b);
        }
        for (Reference r : c.getReference()) {
            if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
            b = new JavaCompositeElement();
            b.isReference = true;
            b.interfaceName = ((JavaInterface)r.getInterface()).getInterface();
            b.eo = r.getInterface();
            b.promotedElement = r.getPromote();
            if (r.getPromote2() != null && r.getPromote2().getInterface() != null && r.getPromote2().getInterface() instanceof JavaInterface) {
                b.promotedInterface = ((JavaInterface)r.getPromote2().getInterface()).getInterface();
            }
            beans.add(b);
        }
        for (Component comp : c.getComponent()) {
            b = new ComponentElement();
            if (comp.getImplementation() != null && comp.getImplementation() instanceof JavaImplementation) {
                ((ComponentElement)b).implClassName = ((JavaImplementation)comp.getImplementation()).getClass_();
                ((ComponentElement)b).eo = comp.getImplementation();
                beans.add(b);
            }
            for (ComponentService s : comp.getService()) {
                if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
                JavaComponentElement serviceElt = new JavaComponentElement(null, null);
                serviceElt.interfaceName = ((JavaInterface)s.getInterface()).getInterface();
                serviceElt.eo = s.getInterface();
                ((ComponentElement)b).services.add(serviceElt);
            }
            for (ComponentReference r : comp.getReference()) {
                if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
                JavaComponentElement refElt = new JavaComponentElement(null, null);
                refElt.interfaceName = ((JavaInterface)r.getInterface()).getInterface();
                refElt.eo = r.getInterface();
                ((ComponentElement)b).references.add(refElt);
                if (r.getTarget2() == null || r.getTarget2().getInterface() == null || !(r.getTarget2().getInterface() instanceof JavaInterface)) continue;
                JavaWireElement wireElt = new JavaWireElement();
                wireElt.sourceInterface = refElt.interfaceName;
                wireElt.reference = String.valueOf(comp.getName()) + "/" + r.getName();
                wireElt.targetInterface = ((JavaInterface)r.getTarget2().getInterface()).getInterface();
                wireElt.service = r.getTarget();
                wireElt.eo = r;
                beans.add(wireElt);
            }
        }
        return beans;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentElement
    extends JavaRelationBean {
        String implClassName;
        List<JavaComponentElement> services;
        List<JavaComponentElement> references;

        private ComponentElement() {
            this.services = new ArrayList<JavaComponentElement>();
            this.references = new ArrayList<JavaComponentElement>();
        }

        @Override
        List<Diagnostic> validate(IJavaProject javaProject) {
            ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
            for (JavaComponentElement elt : this.references) {
                List<Diagnostic> diagnostics = elt.validate(javaProject);
                result.addAll(diagnostics);
            }
            ArrayList<String> interfacesToImplement = new ArrayList<String>();
            for (JavaComponentElement elt : this.services) {
                List<Diagnostic> diagnostics = elt.validate(javaProject);
                if (diagnostics.isEmpty()) {
                    interfacesToImplement.add(elt.interfaceName);
                    continue;
                }
                result.addAll(diagnostics);
            }
            if (this.implClassName == null) {
                String msg = Messages.ScaBuilderJavaExtension_20;
                result.add((Diagnostic)new BasicDiagnostic(4, "", 0, msg, new Object[]{this.eo}));
            } else {
                Diagnostic diag = JDTUtils.validateJavaTypeName(this.implClassName, this.eo);
                if (diag != null) {
                    result.add(diag);
                    return result;
                }
                try {
                    String msg;
                    IType iType = javaProject.findType(this.implClassName);
                    if (iType == null) {
                        msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_22, (Object)this.implClassName);
                        result.add((Diagnostic)new BasicDiagnostic(2, "", 0, msg, new Object[]{this.eo}));
                    } else if (!iType.isClass()) {
                        msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_25, (Object)this.implClassName);
                        result.add((Diagnostic)new BasicDiagnostic(4, "", 0, msg, new Object[]{this.eo}));
                    } else {
                        ArrayList<String> superInterfaces = new ArrayList<String>();
                        String[] stringArray = iType.getSuperInterfaceNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            String[][] types = iType.resolveType(t);
                            if (types != null) {
                                String pckName = types[0][0];
                                pckName = String.valueOf(pckName) + (pckName.length() > 0 ? "." : "");
                                superInterfaces.add(String.valueOf(pckName) + types[0][1]);
                            }
                            ++n2;
                        }
                        interfacesToImplement.removeAll(superInterfaces);
                        if (!interfacesToImplement.isEmpty()) {
                            String msg2 = NLS.bind((String)Messages.ScaBuilderJavaExtension_30, (Object)this.implClassName);
                            Iterator it = interfacesToImplement.iterator();
                            while (it.hasNext()) {
                                msg2 = String.valueOf(msg2) + "'" + (String)it.next() + "'";
                                msg2 = it.hasNext() ? String.valueOf(msg2) + ", " : String.valueOf(msg2) + ".";
                            }
                            result.add((Diagnostic)new BasicDiagnostic(4, "", 0, msg2, new Object[]{this.eo}));
                        }
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaComponentElement
    extends JavaRelationBean {
        String interfaceName;

        private JavaComponentElement() {
        }

        @Override
        List<Diagnostic> validate(IJavaProject javaProject) {
            ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
            if (this.interfaceName == null) {
                String msg = Messages.ScaBuilderJavaExtension_7;
                result.add((Diagnostic)new BasicDiagnostic(4, "", 0, msg, new Object[]{this.eo}));
            } else {
                try {
                    Diagnostic diag = JDTUtils.validateJavaTypeName(this.interfaceName, this.eo);
                    if (diag != null) {
                        result.add(diag);
                        return result;
                    }
                    IType iType = javaProject.findType(this.interfaceName);
                    if (iType == null) {
                        String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_9, (Object)this.interfaceName);
                        result.add((Diagnostic)new BasicDiagnostic(2, "", 0, msg, new Object[]{this.eo}));
                    } else if (!iType.isInterface()) {
                        String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_13, (Object)this.interfaceName);
                        result.add((Diagnostic)new BasicDiagnostic(4, "", 0, msg, new Object[]{this.eo}));
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        /* synthetic */ JavaComponentElement(JavaComponentElement javaComponentElement, JavaComponentElement javaComponentElement2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaCompositeElement
    extends JavaComponentElement {
        String promotedInterface;
        String promotedElement;
        boolean isReference = false;

        private JavaCompositeElement() {
        }

        @Override
        List<Diagnostic> validate(IJavaProject javaProject) {
            List<Diagnostic> result = super.validate(javaProject);
            if (result.isEmpty() && this.promotedInterface != null) {
                Diagnostic diag = JDTUtils.validateJavaTypeName(this.promotedInterface, this.eo);
                if (diag != null) {
                    result.add(diag);
                    return result;
                }
                if (!this.promotedInterface.equals(this.interfaceName)) {
                    String classToCheck;
                    String superClass;
                    if (this.isReference) {
                        superClass = this.promotedInterface;
                        classToCheck = this.interfaceName;
                    } else {
                        superClass = this.interfaceName;
                        classToCheck = this.promotedInterface;
                    }
                    try {
                        IType iType = javaProject.findType(classToCheck);
                        ArrayList<String> superInterfaces = new ArrayList<String>();
                        String[] stringArray = iType.getSuperInterfaceNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            String[][] types = iType.resolveType(t);
                            if (types != null) {
                                String pckName = types[0][0];
                                pckName = String.valueOf(pckName) + (pckName.length() > 0 ? "." : "");
                                superInterfaces.add(String.valueOf(pckName) + types[0][1]);
                            }
                            ++n2;
                        }
                        if (!superInterfaces.contains(superClass)) {
                            String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_17, (Object[])new Object[]{classToCheck, superClass});
                            result.add((Diagnostic)new BasicDiagnostic(4, "", 0, msg, new Object[]{this.eo}));
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class JavaRelationBean {
        EObject eo;

        private JavaRelationBean() {
        }

        abstract List<Diagnostic> validate(IJavaProject var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaWireElement
    extends JavaRelationBean {
        String sourceInterface;
        String targetInterface;
        String service;
        String reference;

        private JavaWireElement() {
        }

        @Override
        List<Diagnostic> validate(IJavaProject javaProject) {
            ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
            if (this.sourceInterface != null && this.targetInterface != null) {
                Diagnostic diag = JDTUtils.validateJavaTypeName(this.sourceInterface, this.eo);
                if (diag != null) {
                    result.add(diag);
                    return result;
                }
                diag = JDTUtils.validateJavaTypeName(this.targetInterface, this.eo);
                if (diag != null) {
                    result.add(diag);
                    return result;
                }
                if (!this.sourceInterface.equals(this.targetInterface)) {
                    try {
                        IType iType = javaProject.findType(this.targetInterface);
                        ArrayList<String> superInterfaces = new ArrayList<String>();
                        String[] stringArray = iType.getSuperInterfaceNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String t = stringArray[n2];
                            String[][] types = iType.resolveType(t);
                            if (types != null) {
                                String pckName = types[0][0];
                                pckName = String.valueOf(pckName) + (pckName.length() > 0 ? "." : "");
                                superInterfaces.add(String.valueOf(pckName) + types[0][1]);
                            }
                            ++n2;
                        }
                        if (!superInterfaces.contains(this.sourceInterface)) {
                            String msg = NLS.bind((String)Messages.ScaBuilderJavaExtension_3, (Object[])new Object[]{this.targetInterface, this.sourceInterface});
                            result.add((Diagnostic)new BasicDiagnostic(4, "", 0, msg, new Object[]{this.eo}));
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
            }
            return result;
        }
    }
}

