/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.compositeshell;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.SCAImplementation;
import org.eclipse.stp.sca.ScaFactory;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.util.ScaResourceFactoryImpl;

public class CompositeShellGenerator {
    private IFile compositeFile;
    private IFile destCompositeFile;

    public CompositeShellGenerator(IFile compositeFileC, IFile destCompositeFileC) {
        this.compositeFile = compositeFileC;
        this.destCompositeFile = destCompositeFileC;
    }

    public void createCompositeShell() {
        Composite initialComposite = this.getComposite();
        if (initialComposite != null) {
            this.createCompositeShell(initialComposite);
        }
    }

    private Composite getComposite() {
        Composite result = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.osoa.org/xmlns/sca/1.0", (Object)ScaPackage.eINSTANCE);
        URI uri = URI.createFileURI((String)this.compositeFile.getFullPath().toString());
        try {
            Resource resource = resourceSet.getResource(uri, true);
            for (EObject eObject : resource.getContents()) {
                Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
                if (diagnostic.getSeverity() != 0 || !(eObject instanceof DocumentRoot)) continue;
                result = ((DocumentRoot)eObject).getComposite();
            }
        }
        catch (RuntimeException exception) {
            exception.printStackTrace();
        }
        return result;
    }

    private boolean createCompositeShell(Composite initialComposite) {
        boolean result = false;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ScaResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.osoa.org/xmlns/sca/1.0", (Object)ScaPackage.eINSTANCE);
        URI uri = URI.createFileURI((String)this.destCompositeFile.getFullPath().toString());
        try {
            Resource resource = resourceSet.createResource(uri);
            DocumentRoot documentRoot = ScaFactory.eINSTANCE.createDocumentRoot();
            Composite composite = this.createComposite(initialComposite);
            documentRoot.setComposite(composite);
            Component component = this.createComponent(initialComposite);
            composite.getComponent().add((Object)component);
            for (Service initialService : initialComposite.getService()) {
                this.createService(initialService, composite, component);
            }
            for (Reference initialReference : initialComposite.getReference()) {
                this.createReference(initialReference, composite, component);
            }
            resource.getContents().add((Object)documentRoot);
            resource.save(null);
            result = true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return result;
    }

    private void createReference(Reference initialReference, Composite composite, Component component) {
        Reference compositeReference = ScaFactory.eINSTANCE.createReference();
        compositeReference.setName(initialReference.getName());
        composite.getReference().add((Object)compositeReference);
        ComponentReference componentReference = ScaFactory.eINSTANCE.createComponentReference();
        componentReference.setName(initialReference.getName());
        component.getReference().add((Object)componentReference);
        compositeReference.setPromote2(componentReference);
    }

    private void createService(Service initialService, Composite composite, Component component) {
        Service compositeService = ScaFactory.eINSTANCE.createService();
        compositeService.setName(initialService.getName());
        composite.getService().add((Object)compositeService);
        ComponentService componentService = ScaFactory.eINSTANCE.createComponentService();
        componentService.setName(initialService.getName());
        component.getService().add((Object)componentService);
        compositeService.setPromote2(componentService);
    }

    private Component createComponent(Composite initialComposite) {
        Component component = ScaFactory.eINSTANCE.createComponent();
        component.setName(initialComposite.getName());
        SCAImplementation scaImplementation = ScaFactory.eINSTANCE.createSCAImplementation();
        QName internalCompositeName = new QName(initialComposite.getTargetNamespace(), initialComposite.getName());
        scaImplementation.setName(internalCompositeName);
        ((FeatureMap.Internal)component.getImplementationGroup()).clear();
        ((FeatureMap.Internal)component.getImplementationGroup()).add((EStructuralFeature)ScaPackage.Literals.COMPONENT__IMPLEMENTATION_GROUP, (Object)FeatureMapUtil.createEntry((EStructuralFeature)ScaPackage.Literals.DOCUMENT_ROOT__IMPLEMENTATION_COMPOSITE, (Object)scaImplementation));
        return component;
    }

    private Composite createComposite(Composite initialComposite) {
        Composite composite = ScaFactory.eINSTANCE.createComposite();
        composite.setName(this.destCompositeFile.getName().replaceAll("." + this.destCompositeFile.getFileExtension(), ""));
        composite.setTargetNamespace(initialComposite.getTargetNamespace());
        return composite;
    }
}

