/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.Wire;
import org.eclipse.stp.sca.diagram.edit.policies.ScaBaseItemSemanticEditPolicy;

public class WireReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public WireReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Wire)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ComponentReference) || !(this.newEnd instanceof ComponentReference)) {
            return false;
        }
        ComponentService target = this.getLink().getTarget2();
        if (!(this.getLink().eContainer() instanceof Composite)) {
            return false;
        }
        Composite container = (Composite)this.getLink().eContainer();
        return ScaBaseItemSemanticEditPolicy.LinkConstraints.canExistWire_4003(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ComponentService) || !(this.newEnd instanceof ComponentService)) {
            return false;
        }
        ComponentReference source = this.getLink().getSource2();
        if (!(this.getLink().eContainer() instanceof Composite)) {
            return false;
        }
        Composite container = (Composite)this.getLink().eContainer();
        return ScaBaseItemSemanticEditPolicy.LinkConstraints.canExistWire_4003(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() {
        this.getLink().setSource2(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() {
        this.getLink().setTarget2(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Wire getLink() {
        return (Wire)this.getElementToEdit();
    }

    protected ComponentReference getOldSource() {
        return (ComponentReference)this.oldEnd;
    }

    protected ComponentReference getNewSource() {
        return (ComponentReference)this.newEnd;
    }

    protected ComponentService getOldTarget() {
        return (ComponentService)this.oldEnd;
    }

    protected ComponentService getNewTarget() {
        return (ComponentService)this.newEnd;
    }
}

