/*
 * Decompiled with CFR 0.152.
 */
package sca.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stp.sca.Binding;
import org.eclipse.stp.sca.provider.ScaEditPlugin;
import sca.provider.ExtensionBindingException;
import sca.provider.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsRegistryReader {
    public static final String BINDINGS_EXTENSION_POINT_ID = "org.eclipse.stp.sca.edit.bindings";
    public static BindingsRegistryReader INSTANCE = new BindingsRegistryReader();
    private static List<ExtensionBinding> fExtensions = null;

    private List<ExtensionBinding> loadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(BINDINGS_EXTENSION_POINT_ID);
        IConfigurationElement[] points = extensionPoint.getConfigurationElements();
        ArrayList<ExtensionBinding> bindings = new ArrayList<ExtensionBinding>();
        int i = 0;
        while (i < points.length) {
            try {
                this.readElement(points[i]);
            }
            catch (ExtensionBindingException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return bindings;
    }

    private void readElement(IConfigurationElement element) throws ExtensionBindingException {
        if ("category".equals(element.getName())) {
            BindingsRegistryReader.loadCategory(element);
        } else if ("binding".equals(element.getName())) {
            ExtensionBinding bindingExtension = new ExtensionBinding(element);
            fExtensions.add(bindingExtension);
        } else {
            throw new ExtensionBindingException(String.valueOf(Messages.getString("BindingsRegistryReader_7")) + element.getName());
        }
    }

    public List<ExtensionBinding> getExtensionBindings() {
        if (fExtensions == null) {
            fExtensions = new ArrayList<ExtensionBinding>();
            INSTANCE.loadExtensions();
        }
        return fExtensions;
    }

    private static void loadCategory(IConfigurationElement element2) {
    }

    public static class ExtensionBinding {
        private static final String BINDING_CLASS = "class";
        private static final String BINDING_NS_URI = "nsURI";
        protected Binding fBinding = null;
        protected IConfigurationElement element;
        EStructuralFeature df;

        public ExtensionBinding(IConfigurationElement element) {
            this.element = element;
        }

        public Binding getBinding() {
            if (this.fBinding == null) {
                try {
                    this.loadBinding();
                }
                catch (ExtensionBindingException e) {
                    e.printStackTrace();
                }
            }
            return this.fBinding;
        }

        public String getName() {
            return this.element.getAttribute("name");
        }

        protected void loadBinding() throws ExtensionBindingException {
            String fullClassName = this.element.getAttribute(BINDING_CLASS);
            String nsURI = this.element.getAttribute(BINDING_NS_URI);
            String[] classWords = fullClassName.split("\\.");
            String className = classWords[classWords.length - 1];
            EClassifier bindingClassifier = EPackage.Registry.INSTANCE.getEPackage(nsURI).getEClassifier(className);
            if (bindingClassifier == null) {
                throw new ExtensionBindingException(String.valueOf(Messages.getString("BindingsRegistryReader_0")) + className + Messages.getString("BindingsRegistryReader_1") + nsURI + ">");
            }
            this.df = bindingClassifier.eContainingFeature();
            if (bindingClassifier instanceof EClass) {
                EObject bindingObject = EcoreUtil.create((EClass)((EClass)bindingClassifier));
                if (bindingObject == null || !(bindingObject instanceof Binding)) {
                    throw new ExtensionBindingException(String.valueOf(Messages.getString("BindingsRegistryReader_3")) + fullClassName + Messages.getString("BindingsRegistryReader_4"));
                }
                this.fBinding = (Binding)bindingObject;
            } else {
                ScaEditPlugin.getPlugin().log(new ExtensionBindingException(String.valueOf(Messages.getString("BindingsRegistryReader_5")) + fullClassName + Messages.getString("BindingsRegistryReader_6")));
            }
        }
    }
}

