/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.introspection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.Interface;
import org.eclipse.stp.sca.JavaImplementation;
import org.eclipse.stp.sca.JavaInterface;
import org.eclipse.stp.sca.ScaFactory;
import org.eclipse.stp.sca.introspection.Messages;
import org.eclipse.stp.sca.introspection.Resolver;
import org.eclipse.stp.sca.introspection.metadata.MetaData;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaInterfaceResolver
implements Resolver {
    private ClassLoader classLoader;
    Logger log = Logger.getLogger(JavaInterfaceResolver.class.getCanonicalName());

    public JavaInterfaceResolver(ClassLoader classLoaderC) {
        this.classLoader = classLoaderC;
    }

    @Override
    public Composite resolve(Composite composite) {
        for (Component c : composite.getComponent()) {
            Implementation imp = c.getImplementation();
            if (imp.eClass().getClassifierID() != 43) continue;
            JavaImplementation javaImpl = (JavaImplementation)imp;
            try {
                Class<?> cl = this.classLoader.loadClass(javaImpl.getClass_());
                MetaData ccmd = new MetaData(cl);
                this.resolveServices(c, ccmd);
                this.resolveReferences(c, ccmd);
            }
            catch (ClassNotFoundException e) {
                this.log.fine(String.valueOf(Messages.JavaInterfaceResolver_0) + javaImpl.getClass_());
            }
        }
        return composite;
    }

    public void resolveServices(Component component, MetaData<?> cMetaData) {
        Class[] i;
        Service s = cMetaData.getAnnotation(Service.class);
        Class[] interfaces = null;
        if (s != null) {
            interfaces = s.interfaces().length < 1 ? new Class[]{s.value()} : s.interfaces();
        } else {
            JavaImplementation javaImpl = (JavaImplementation)component.getImplementation();
            try {
                Class<?> implementation = this.classLoader.loadClass(javaImpl.getClass_());
                interfaces = implementation.getInterfaces();
            }
            catch (ClassNotFoundException e) {
                this.log.severe(String.valueOf(Messages.JavaInterfaceResolver_1) + javaImpl.getClass_() + Messages.JavaInterfaceResolver_2);
                e.printStackTrace();
            }
        }
        HashMap<String, String> serviceMap = new HashMap<String, String>();
        HashMap<String, String> missingServiceMap = new HashMap<String, String>();
        EList serviceList = component.getService();
        for (ComponentService componentService : serviceList) {
            Interface itf = componentService.getInterface();
            if (itf != null) {
                if (componentService.getInterface().eClass().getClassifierID() != 44) continue;
                serviceMap.put(componentService.getName(), ((JavaInterface)componentService.getInterface()).getInterface());
                continue;
            }
            i = ScaFactory.eINSTANCE.createJavaInterface();
            i.setInterface(interfaces[0].getCanonicalName());
            componentService.setInterface((Interface)i);
            serviceMap.put(componentService.getName(), interfaces[0].getCanonicalName());
        }
        i = interfaces;
        int n = i.length;
        int n2 = 0;
        while (n2 < n) {
            JavaInterface jInterface = i[n2];
            if (!serviceMap.containsValue(jInterface.getName())) {
                String sName = jInterface.getSimpleName();
                missingServiceMap.put(sName, jInterface.getName());
            }
            ++n2;
        }
        Set serviceSet = missingServiceMap.keySet();
        for (String key : serviceSet) {
            ComponentService c = ScaFactory.eINSTANCE.createComponentService();
            JavaInterface i2 = ScaFactory.eINSTANCE.createJavaInterface();
            i2.setInterface((String)missingServiceMap.get(key));
            c.setName(key);
            c.setInterface((Interface)i2);
            component.getService().add((Object)c);
        }
    }

    public void resolveReferences(Component component, MetaData<?> cMetaData) {
        AccessibleObject[] o = cMetaData.getAllAnnotatedMethodsAndFields(Reference.class);
        if (o != null) {
            HashMap<String, String> referenceMap = new HashMap<String, String>();
            HashMap<String, String> referenceDecMap = new HashMap<String, String>();
            AccessibleObject[] accessibleObjectArray = o;
            int n = o.length;
            int n2 = 0;
            while (n2 < n) {
                AccessibleObject object = accessibleObjectArray[n2];
                referenceDecMap.put(this.getReferenceName(object), this.getReferenceClassName(object));
                ++n2;
            }
            EList referenceList = component.getReference();
            for (ComponentReference componentReference : referenceList) {
                Interface itf = componentReference.getInterface();
                if (itf != null) {
                    if (itf.eClass().getClassifierID() != 44) continue;
                    referenceMap.put(componentReference.getName(), ((JavaInterface)componentReference.getInterface()).getInterface());
                    continue;
                }
                String referenceName = componentReference.getName();
                String interfaceClass = (String)referenceDecMap.get(referenceName);
                if (interfaceClass == null) continue;
                JavaInterface newJavaItf = ScaFactory.eINSTANCE.createJavaInterface();
                newJavaItf.setInterface(interfaceClass);
                componentReference.setInterface((Interface)newJavaItf);
                referenceMap.put(referenceName, interfaceClass);
            }
            Set references = referenceDecMap.keySet();
            for (String key : references) {
                if (referenceMap.containsKey(key)) continue;
                ComponentReference c = ScaFactory.eINSTANCE.createComponentReference();
                JavaInterface i = ScaFactory.eINSTANCE.createJavaInterface();
                i.setInterface((String)referenceDecMap.get(key));
                c.setName(key);
                c.setInterface((Interface)i);
                component.getReference().add((Object)c);
            }
        }
    }

    private String getReferenceClassName(AccessibleObject object) {
        Method method;
        Class<?>[] classe;
        if (object instanceof Field) {
            Field field = (Field)object;
            return field.getType().getCanonicalName();
        }
        if (object instanceof Method && (classe = (method = (Method)object).getParameterTypes()).length > 0) {
            return classe[0].getCanonicalName();
        }
        return null;
    }

    private String getReferenceName(AccessibleObject object) {
        if (object instanceof Field) {
            Field field = (Field)object;
            String name = field.getAnnotation(Reference.class).name();
            if (name.equals("")) {
                name = field.getName();
            }
            return name;
        }
        if (object instanceof Method) {
            Method method = (Method)object;
            String name = method.getAnnotation(Reference.class).name();
            if (name.equals("")) {
                name = method.getName().substring(3);
                name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length());
            }
            return name;
        }
        return null;
    }
}

