/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.introspection;

import java.util.Iterator;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.ScaFactory;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.Wire;
import org.eclipse.stp.sca.introspection.IntrospectionUtils;
import org.eclipse.stp.sca.introspection.Resolver;

public class PromoteResolver
implements Resolver {
    public Composite resolve(Composite composite) {
        this.promoteServices(composite);
        this.promoteReferences(composite);
        return composite;
    }

    private void promoteReferences(Composite composite) {
        for (Reference reference : composite.getReference()) {
            String componentName;
            Component component;
            if (reference.getPromote() == null || reference.getPromote().indexOf("/") != -1 || (component = IntrospectionUtils.getComponent(composite, componentName = reference.getPromote())).getReference().size() != 1) continue;
            reference.setPromote2((ComponentReference)component.getReference().get(0));
        }
        for (Component component : composite.getComponent()) {
            for (ComponentReference cr : component.getReference()) {
                if (this.isComponentReferenceUsed(composite, cr)) continue;
                Reference reference = ScaFactory.eINSTANCE.createReference();
                reference.setName(cr.getName());
                reference.setPromote2(cr);
                composite.getReference().add((Object)reference);
            }
        }
    }

    private boolean isComponentReferenceUsed(Composite composite, ComponentReference cr) {
        boolean used = false;
        boolean bl = used = cr.getTarget2() != null;
        if (!used) {
            for (Wire wire : composite.getWire()) {
                if (!wire.getSource2().equals(cr)) continue;
                used = true;
                break;
            }
        }
        if (!used) {
            Iterator it = composite.getReference().iterator();
            while (!used && it.hasNext()) {
                Reference reference = (Reference)it.next();
                if (reference.getPromote2() == null) continue;
                used = reference.getPromote2().equals(cr);
            }
        }
        return used;
    }

    private void promoteServices(Composite composite) {
        for (Service service : composite.getService()) {
            String componentName;
            Component component;
            if (service.getPromote() == null || service.getPromote().indexOf("/") != -1 || (component = IntrospectionUtils.getComponent(composite, componentName = service.getPromote())).getService().size() != 1) continue;
            service.setPromote2((ComponentService)component.getService().get(0));
        }
        for (Component component : composite.getComponent()) {
            for (ComponentService cs : component.getService()) {
                if (this.isComponentServiceUsed(composite, cs)) continue;
                Service service = ScaFactory.eINSTANCE.createService();
                service.setName(cs.getName());
                service.setPromote2(cs);
                composite.getService().add((Object)service);
            }
        }
    }

    private boolean isComponentServiceUsed(Composite composite, ComponentService cs) {
        boolean used = false;
        if (!used) {
            for (Wire wire : composite.getWire()) {
                if (!wire.getTarget2().equals(cs)) continue;
                used = true;
                break;
            }
        }
        Iterator it = composite.getService().iterator();
        while (!used && it.hasNext()) {
            Service service = (Service)it.next();
            if (service.getPromote2() == null) continue;
            used = service.getPromote2().equals(cs);
        }
        if (!used) {
            Iterator it1 = composite.getComponent().iterator();
            while (!used && it1.hasNext()) {
                Component component = (Component)it1.next();
                Iterator it2 = component.getReference().iterator();
                while (!used && it2.hasNext()) {
                    ComponentReference ref = (ComponentReference)it2.next();
                    if (ref.getTarget2() == null) continue;
                    used = ref.getTarget2().equals(cs);
                }
            }
        }
        return used;
    }
}

