/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.ontology.view.Messages;
import org.eclipse.stp.sca.ontology.view.OntologyToolTip;
import org.eclipse.stp.sca.ontology.view.OntologyViewPlugin;
import org.eclipse.stp.sca.ontology.view.mock.OntModel;
import org.eclipse.stp.sca.ontology.view.preferences.OntologySourcesDialog;
import org.eclipse.stp.sca.ontology.view.preferences.OntologySourcesPreferences;
import org.eclipse.stp.sca.ontology.view.search.ClassBrowser;
import org.eclipse.stp.sca.ontology.view.search.OntologyModelManager;
import org.eclipse.stp.sca.ontology.view.search.OntologySearchResult;
import org.eclipse.stp.sca.ontology.view.viewer.OntologyFlatContentProvider;
import org.eclipse.stp.sca.ontology.view.viewer.OntologyHierarchicalContentProvider;
import org.eclipse.stp.sca.ontology.view.viewer.OntologyViewerFilter;
import org.eclipse.stp.sca.ontology.view.viewer.OntologyViewerInput;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class OntologyBrowserView
extends ViewPart {
    private Image searchImage = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/search.gif").createImage();
    private Image backImage = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/back.gif").createImage();
    private Image forwardImage = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/forward.gif").createImage();
    private Image ontologyImage = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/ontology.gif").createImage();
    private Image categoryImage = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/category.gif").createImage();
    private Image fImage = OntologyViewPlugin.getImageDescriptor("icons/sample.gif").createImage();
    private FormToolkit toolkit;
    private Form form;
    public static final int NUM_RESULT_PER_PAGE = 25;
    private int page = 1;
    private Text searchBar;
    private TreeViewer viewer;
    private OntologyFlatContentProvider flatContentProvider = new OntologyFlatContentProvider();
    private OntologyHierarchicalContentProvider hierarchicalContentProvider = new OntologyHierarchicalContentProvider();
    private OntologyViewerFilter viewerFilter = new OntologyViewerFilter(this.page);
    private OntologyViewerInput viewerInput = new OntologyViewerInput();
    private OntologyToolTip tooltip;
    private Label previousPageLink;
    private Label nextPageLink;
    private CCombo pagesCombo;
    private Label paginationLabel;
    private Action searchExactAction;
    private Action searchAllAction;
    private Action searchAnyAction;
    private Action flatViewAction;
    private Action hierarchicalViewAction;

    public OntologyBrowserView() {
        IRunnableWithProgress loadingOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        HashMap<String, Boolean> sources = new HashMap<String, Boolean>();
                        if (OntologySourcesPreferences.getSourcesUse(true)) {
                            sources.putAll(OntologySourcesPreferences.getSavedLocations(true));
                        }
                        if (OntologySourcesPreferences.getSourcesUse(false)) {
                            sources.putAll(OntologySourcesPreferences.getSavedLocations(false));
                        }
                        monitor.beginTask(Messages.OwlBrowserView_5, sources.size());
                        for (Map.Entry entry : sources.entrySet()) {
                            monitor.setTaskName(NLS.bind((String)Messages.OwlBrowserView_6, entry.getKey()));
                            if (((Boolean)entry.getValue()).booleanValue()) {
                                OntologyModelManager.INSTANCE.addModelFile((String)entry.getKey());
                            }
                            monitor.worked(1);
                            if (!monitor.isCanceled()) continue;
                            throw new InterruptedException();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, loadingOperation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        Composite searchBarContainer = this.toolkit.createComposite(this.form.getHead());
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 8;
        searchBarContainer.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        searchBarContainer.setLayoutData((Object)layoutData);
        this.form.setHeadClient((Control)searchBarContainer);
        Label searchLabel = this.toolkit.createLabel(searchBarContainer, Messages.OwlBrowserView_8);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        searchLabel.setLayoutData((Object)layoutData);
        this.searchBar = this.toolkit.createText(searchBarContainer, "", 2048);
        layoutData = new GridData(768);
        this.searchBar.setLayoutData((Object)layoutData);
        this.searchBar.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n' || e.keyCode == 0x1000050) {
                    OntologyBrowserView.this.performSearch();
                }
            }
        });
        Button searchButton = this.toolkit.createButton(searchBarContainer, Messages.OwlBrowserView_10, 8);
        searchButton.setImage(this.searchImage);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OntologyBrowserView.this.performSearch();
            }
        });
        layout = new GridLayout();
        layout.marginWidth = 0;
        this.form.getBody().setLayout((Layout)layout);
        this.form.getBody().setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer(this.form.getBody(), 770);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)this.flatContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == OntologyFlatContentProvider.RESULT_ROOT) {
                    return NLS.bind((String)Messages.OwlBrowserView_11, (Object)OntologyBrowserView.this.viewerInput.getNumberOfConcepts());
                }
                if (element instanceof OntologySearchResult) {
                    OntologySearchResult bean = (OntologySearchResult)element;
                    return bean.getName();
                }
                if (element instanceof String) {
                    String uri = (String)element;
                    uri = uri.substring(uri.lastIndexOf(47) + 1);
                    return String.valueOf(uri) + " (" + OntologyBrowserView.this.viewerInput.getNumberOfConcepts((String)element) + ")";
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                if (element instanceof OntologySearchResult) {
                    return OntologyBrowserView.this.ontologyImage;
                }
                if (element instanceof String) {
                    return OntologyBrowserView.this.categoryImage;
                }
                return null;
            }
        });
        this.viewer.addFilter((ViewerFilter)this.viewerFilter);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 5;
        this.viewer.addDragSupport(operations, types, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                Object data = ((StructuredSelection)OntologyBrowserView.this.viewer.getSelection()).getFirstElement();
                if (data instanceof OntologySearchResult) {
                    event.data = ((OntologySearchResult)data).getAnnotation();
                }
            }

            public void dragStart(DragSourceEvent event) {
                event.doit = !OntologyBrowserView.this.viewer.getSelection().isEmpty();
            }
        });
        this.viewer.setInput((Object)this.viewerInput);
        this.tooltip = new OntologyToolTip((Control)this.viewer.getTree());
        this.addNavigationBar(this.form.getBody());
        this.createActions();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.stp.sca.ontology.view.viewer");
    }

    private void performSearch() {
        String query = this.searchBar.getText().trim();
        if (query.length() == 0) {
            return;
        }
        this.viewerInput.clearAllConcepts();
        for (Map.Entry<URI, OntModel> entry : OntologyModelManager.INSTANCE.getModels().entrySet()) {
            List<OntologySearchResult> concepts = ClassBrowser.INSTANCE.searchClasses(entry.getValue(), query, this.getSearchStyle());
            this.viewerInput.addConcepts(entry.getKey().toString(), concepts);
        }
        this.tooltip.updateKeywordsToHighlight(query);
        this.goToPage(1);
    }

    private void goToPage(int page) {
        this.page = page;
        this.viewerFilter.setPage(page);
        this.viewer.refresh();
        this.viewer.expandAll();
        this.updatePagination();
    }

    private void addNavigationBar(Composite parent) {
        Composite navigationBar = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        navigationBar.setLayout((Layout)layout);
        navigationBar.setLayoutData((Object)new GridData(768));
        Label separator = this.toolkit.createSeparator(navigationBar, 256);
        separator.setLayoutData((Object)new GridData(768));
        Composite arrowIcons = this.toolkit.createComposite(navigationBar);
        layout = new GridLayout(3, false);
        layout.horizontalSpacing = 15;
        layout.marginHeight = 0;
        layout.marginTop = 10;
        layout.marginBottom = 4;
        arrowIcons.setLayout((Layout)layout);
        arrowIcons.setLayoutData((Object)new GridData(0x1000000, 1024, true, false));
        this.previousPageLink = this.toolkit.createLabel(arrowIcons, "<");
        this.previousPageLink.setImage(this.backImage);
        this.previousPageLink.setEnabled(false);
        this.previousPageLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                OntologyBrowserView.this.goToPage(OntologyBrowserView.this.page - 1);
            }
        });
        this.paginationLabel = this.toolkit.createLabel(arrowIcons, "");
        this.paginationLabel.setLayoutData((Object)new GridData(0, 0x1000000, true, true));
        this.nextPageLink = this.toolkit.createLabel(arrowIcons, ">");
        this.nextPageLink.setImage(this.forwardImage);
        this.nextPageLink.setEnabled(false);
        this.nextPageLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                OntologyBrowserView.this.goToPage(OntologyBrowserView.this.page + 1);
            }
        });
        Composite browser = this.toolkit.createComposite(navigationBar);
        browser.setLayout((Layout)new GridLayout(2, false));
        browser.setLayoutData((Object)new GridData(4, 1024, true, false));
        Label label = this.toolkit.createLabel(browser, Messages.OwlBrowserView_20);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        this.pagesCombo = new CCombo(browser, 2060);
        this.toolkit.adapt((Composite)this.pagesCombo);
        this.pagesCombo.setLayoutData((Object)new GridData(16384, 0, true, false));
        this.pagesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int index = OntologyBrowserView.this.pagesCombo.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                int page = Integer.parseInt(OntologyBrowserView.this.pagesCombo.getItem(index));
                OntologyBrowserView.this.goToPage(page);
            }
        });
    }

    public void updatePagination() {
        if (this.page < this.getNumberOfPages()) {
            this.nextPageLink.setEnabled(true);
        } else {
            this.nextPageLink.setEnabled(false);
        }
        if (this.page > 1) {
            this.previousPageLink.setEnabled(true);
        } else {
            this.previousPageLink.setEnabled(false);
        }
        this.paginationLabel.setText(NLS.bind((String)Messages.OwlBrowserView_21, (Object[])new Object[]{this.page, this.getNumberOfPages()}));
        this.paginationLabel.getParent().getParent().layout();
        this.paginationLabel.update();
        this.pagesCombo.removeAll();
        int i = 1;
        while (i <= this.getNumberOfPages()) {
            this.pagesCombo.add(String.valueOf(i));
            ++i;
        }
    }

    private int getNumberOfPages() {
        double pageNumber = this.viewerInput.getNumberOfConcepts() / 25;
        pageNumber = pageNumber == 0.0 ? 1.0 : pageNumber;
        return pageNumber == 1.0 ? 1 : new Double(pageNumber).intValue();
    }

    public void setFocus() {
        this.searchBar.setFocus();
        this.searchBar.setSelection(this.searchBar.getText().length());
    }

    public void dispose() {
        this.toolkit.dispose();
        this.searchImage.dispose();
        this.backImage.dispose();
        this.forwardImage.dispose();
        this.ontologyImage.dispose();
        this.categoryImage.dispose();
        this.fImage.dispose();
        super.dispose();
    }

    private int getSearchStyle() {
        if (this.searchAllAction.isChecked()) {
            return 0;
        }
        if (this.searchExactAction.isChecked()) {
            return 2;
        }
        return 1;
    }

    private void createActions() {
        Action clearResultsAction = new Action(){

            public void run() {
                OntologyBrowserView.this.page = 1;
                OntologyBrowserView.this.viewerInput.clearAllConcepts();
                OntologyBrowserView.this.viewerFilter.setPage(OntologyBrowserView.this.page);
                OntologyBrowserView.this.viewer.refresh();
                OntologyBrowserView.this.updatePagination();
            }
        };
        clearResultsAction.setText(Messages.OwlBrowserView_24);
        clearResultsAction.setToolTipText(Messages.OwlBrowserView_25);
        ImageDescriptor clearResultsDesc = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/clear.gif");
        clearResultsAction.setImageDescriptor(clearResultsDesc);
        this.flatViewAction = new Action(Messages.OwlBrowserView_27, 2){

            public void run() {
                ISelection selection = OntologyBrowserView.this.viewer.getSelection();
                OntologyBrowserView.this.viewer.setContentProvider((IContentProvider)OntologyBrowserView.this.flatContentProvider);
                OntologyBrowserView.this.viewerFilter.resetCount();
                OntologyBrowserView.this.viewer.refresh();
                OntologyBrowserView.this.viewer.expandAll();
                OntologyBrowserView.this.viewer.setSelection(selection);
                OntologyBrowserView.this.updatePagination();
                OntologyBrowserView.this.flatViewAction.setChecked(true);
                OntologyBrowserView.this.hierarchicalViewAction.setChecked(false);
            }
        };
        this.flatViewAction.setToolTipText(Messages.OwlBrowserView_28);
        ImageDescriptor flatViewDesc = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/flat.gif");
        this.flatViewAction.setImageDescriptor(flatViewDesc);
        this.hierarchicalViewAction = new Action(Messages.OwlBrowserView_30, 2){

            public void run() {
                ISelection selection = OntologyBrowserView.this.viewer.getSelection();
                OntologyBrowserView.this.viewer.setContentProvider((IContentProvider)OntologyBrowserView.this.hierarchicalContentProvider);
                OntologyBrowserView.this.viewerFilter.resetCount();
                OntologyBrowserView.this.viewer.refresh();
                OntologyBrowserView.this.viewer.expandAll();
                OntologyBrowserView.this.viewer.setSelection(selection);
                OntologyBrowserView.this.updatePagination();
                OntologyBrowserView.this.flatViewAction.setChecked(false);
                OntologyBrowserView.this.hierarchicalViewAction.setChecked(true);
            }
        };
        this.hierarchicalViewAction.setToolTipText(Messages.OwlBrowserView_31);
        ImageDescriptor hierarchicalViewDesc = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/hierarchical.gif");
        this.hierarchicalViewAction.setImageDescriptor(hierarchicalViewDesc);
        Action modifyOwlSourcesAction = new Action(Messages.OwlBrowserView_33, 2){

            public void run() {
                new OntologySourcesDialog(OntologyBrowserView.this.getViewSite().getShell()).open();
            }
        };
        this.searchAnyAction = new Action(Messages.OwlBrowserView_1, 2){

            public void run() {
                OntologyBrowserView.this.searchAllAction.setChecked(false);
                OntologyBrowserView.this.searchAnyAction.setChecked(true);
                OntologyBrowserView.this.searchExactAction.setChecked(false);
            }
        };
        this.searchAnyAction.setToolTipText(Messages.OwlBrowserView_2);
        ImageDescriptor anyDesc = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/any.gif");
        this.searchAnyAction.setImageDescriptor(anyDesc);
        this.searchAllAction = new Action(Messages.OwlBrowserView_3, 2){

            public void run() {
                OntologyBrowserView.this.searchAllAction.setChecked(true);
                OntologyBrowserView.this.searchAnyAction.setChecked(false);
                OntologyBrowserView.this.searchExactAction.setChecked(false);
            }
        };
        this.searchAllAction.setToolTipText(Messages.OwlBrowserView_4);
        ImageDescriptor allDesc = OntologyViewPlugin.getImageDescriptor("icons/full/obj16/all.gif");
        this.searchAllAction.setImageDescriptor(allDesc);
        this.searchExactAction = new Action(Messages.OwlBrowserView_7, 2){

            public void run() {
                OntologyBrowserView.this.searchAllAction.setChecked(false);
                OntologyBrowserView.this.searchAnyAction.setChecked(false);
                OntologyBrowserView.this.searchExactAction.setChecked(true);
            }
        };
        this.searchExactAction.setToolTipText(Messages.OwlBrowserView_9);
        ImageDescriptor exactDesc = OntologyViewPlugin.getImageDescriptor("icons/sample.gif");
        this.searchExactAction.setImageDescriptor(exactDesc);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)this.searchAnyAction);
        bars.getMenuManager().add((IAction)this.searchAllAction);
        bars.getMenuManager().add((IAction)this.searchExactAction);
        bars.getMenuManager().add((IContributionItem)new Separator());
        bars.getMenuManager().add((IAction)this.flatViewAction);
        bars.getMenuManager().add((IAction)this.hierarchicalViewAction);
        bars.getMenuManager().add((IContributionItem)new Separator());
        bars.getMenuManager().add((IAction)clearResultsAction);
        bars.getMenuManager().add((IAction)modifyOwlSourcesAction);
        bars.getToolBarManager().add((IAction)this.searchAnyAction);
        bars.getToolBarManager().add((IAction)this.searchAllAction);
        bars.getToolBarManager().add((IAction)this.searchExactAction);
        bars.getToolBarManager().add((IContributionItem)new Separator());
        bars.getToolBarManager().add((IAction)clearResultsAction);
        this.searchAnyAction.setChecked(true);
        this.flatViewAction.setChecked(true);
    }
}

