/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.stp.sca.ontology.view.OntologyViewPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologySourcesPreferences {
    private static final String LOCAL_SOURCES_PREFS = "org.eclipse.stp.sca.ontology.view.sources.local.prefs";
    private static final String REMOTE_SOURCES_PREFS = "org.eclipse.stp.sca.ontology.view.sources.remote.prefs";
    private static final String USE_LOCAL_SOURCES_PREFS = "org.eclipse.stp.sca.ontology.view.sources.local.use.prefs";
    private static final String USE_REMOTE_SOURCES_PREFS = "org.eclipse.stp.sca.ontology.view.sources.remote.use.prefs";

    public static void saveOwlSourcesLocation(Map<String, Boolean> fileLocations, boolean isLocal) {
        if (isLocal) {
            OntologySourcesPreferences.saveOwlSourcesLocation(LOCAL_SOURCES_PREFS, fileLocations);
        } else {
            OntologySourcesPreferences.saveOwlSourcesLocation(REMOTE_SOURCES_PREFS, fileLocations);
        }
    }

    public static Map<String, Boolean> getSavedLocations(boolean isLocal) {
        if (isLocal) {
            return OntologySourcesPreferences.retrieveListFromPS(LOCAL_SOURCES_PREFS);
        }
        return OntologySourcesPreferences.retrieveListFromPS(REMOTE_SOURCES_PREFS);
    }

    private static void saveOwlSourcesLocation(String key, Map<String, Boolean> fileLocations) {
        try {
            String prefs = "";
            for (Map.Entry<String, Boolean> entry : fileLocations.entrySet()) {
                prefs = String.valueOf(prefs) + entry.getValue().toString() + " " + entry.getKey() + "\n";
            }
            OntologyViewPlugin.getDefault().getPreferenceStore().setValue(key, prefs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Boolean> retrieveListFromPS(String key) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            String pref = OntologyViewPlugin.getDefault().getPreferenceStore().getString(key);
            if (pref.trim().length() == 0) {
                return map;
            }
            String[] stringArray = pref.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] values = line.split(" ", 2);
                Boolean bool = Boolean.parseBoolean(values[0]);
                map.put(values[1].trim(), bool);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static boolean getSourcesUse(boolean isLocal) {
        if (isLocal) {
            return OntologyViewPlugin.getDefault().getPreferenceStore().getBoolean(USE_LOCAL_SOURCES_PREFS);
        }
        return OntologyViewPlugin.getDefault().getPreferenceStore().getBoolean(USE_REMOTE_SOURCES_PREFS);
    }

    public static void setSourcesUse(boolean value, boolean isLocal) {
        if (isLocal) {
            OntologyViewPlugin.getDefault().getPreferenceStore().setValue(USE_LOCAL_SOURCES_PREFS, value);
        } else {
            OntologyViewPlugin.getDefault().getPreferenceStore().setValue(USE_REMOTE_SOURCES_PREFS, value);
        }
    }
}

