/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.sca.xmleditor.utils.IncludesUtils;
import org.eclipse.stp.sca.xmleditor.utils.ScaUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScaXmlContentProvider
implements ITreeContentProvider {
    private IFile editedFile;
    private Viewer viewer;
    private IncludesUtils includesUtils;
    private Map<Node, Node> includeNodes = new HashMap<Node, Node>();
    private IModelStateListener modelListener = new IModelStateListener(){

        public void modelChanged(IStructuredModel model) {
            ScaXmlContentProvider.this.refreshViewer();
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
            try {
                ScaXmlContentProvider.this.refreshViewer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }
    };

    public ScaXmlContentProvider() {
    }

    public ScaXmlContentProvider(IFile editedFile) {
        this.editedFile = editedFile;
    }

    public Object[] getChildren(Object parentElement) {
        Node node;
        if (parentElement instanceof Node && (node = (Node)parentElement).getNodeType() == 1 && node.getNodeName() != null) {
            NodeList children = node.getChildNodes();
            if (children == null) {
                return new Object[0];
            }
            ArrayList<Node> result = new ArrayList<Node>();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1 && node.getNodeName() != null) {
                    result.add(child);
                }
                ++i;
            }
            if (!node.getNodeName().toLowerCase().equals("include") && !node.getNodeName().toLowerCase().endsWith(":include")) {
                return result.toArray();
            }
            if (this.includesUtils == null) {
                return result.toArray();
            }
            QName includeQName = ScaUtils.getIncludeQName(node);
            if (includeQName == null) {
                return result.toArray();
            }
            IFile includedFile = this.includesUtils.getIFile(includeQName);
            if (includedFile == null) {
                return result.toArray();
            }
            Document includedDocument = this.includesUtils.getDOM(includedFile);
            if (includedDocument == null) {
                return result.toArray();
            }
            Node compositeNode = ScaUtils.getScaTopNode(includedDocument);
            children = compositeNode.getChildNodes();
            if (children == null) {
                return result.toArray();
            }
            int i2 = 0;
            while (i2 < children.getLength()) {
                Node child = children.item(i2);
                if (child.getNodeType() == 1 && node.getNodeName() != null) {
                    result.add(child);
                    this.includeNodes.put(child, node);
                }
                ++i2;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        Node node;
        if (element instanceof Node && (node = (Node)element).getNodeType() == 1 && node.getNodeName() != null) {
            if (!this.includeNodes.containsKey(node)) {
                return node.getParentNode();
            }
            return this.includeNodes.get(node);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        Object rootDocument = null;
        if (inputElement instanceof IDOMModel) {
            IDOMDocument topNode = ((IDOMModel)inputElement).getDocument();
            rootDocument = topNode;
            String workspaceRelativePath = topNode.getModel().getBaseLocation();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(workspaceRelativePath);
            if (resource == null || !IFile.class.isAssignableFrom(resource.getClass())) {
                return new Object[0];
            }
            this.editedFile = (IFile)resource;
            this.defineWorkspaceResources();
        }
        if (inputElement instanceof Document) {
            rootDocument = (Document)inputElement;
        }
        if (rootDocument != null) {
            Node root = rootDocument.getFirstChild();
            while (root != null && root.getNodeType() != 1) {
                root = root.getNextSibling();
            }
            if (root != null && root.getNodeName() != null && ScaUtils.removeNamespacePrefix(root.getNodeName()).toLowerCase().equals("composite")) {
                return new Object[]{root};
            }
            if (root != null && root.getNodeName() != null && ScaUtils.removeNamespacePrefix(root.getNodeName()).toLowerCase().equals("componenttype")) {
                return new Object[]{root};
            }
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (oldInput != null && oldInput instanceof IDOMModel) {
            ((IDOMModel)oldInput).removeModelStateListener(this.modelListener);
        }
        this.includeNodes.clear();
        if (newInput != null && newInput instanceof IDOMModel) {
            ((IDOMModel)newInput).addModelStateListener(this.modelListener);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                TreeViewer tv;
                if (viewer != null && viewer instanceof TreeViewer && (tv = (TreeViewer)viewer).getTree() != null && !tv.getTree().isDisposed()) {
                    tv.expandAll();
                }
            }
        });
    }

    private void refreshViewer() {
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void defineWorkspaceResources() {
        IProject project = this.editedFile.getProject();
        this.includesUtils = IncludesUtils.createIncludesUtils(project);
    }

    static /* synthetic */ void access$0(ScaXmlContentProvider scaXmlContentProvider) {
        scaXmlContentProvider.refreshViewer();
    }
}

