/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPreferences {
    private static final ScaXmlPlatform fabric3 = new ScaXmlPlatform("Fabric3");
    private static final ScaXmlPlatform pFrascati = new ScaXmlPlatform("FraSCAti / PEtALS");
    private static final ScaXmlPlatform tuscany = new ScaXmlPlatform("Tuscany");
    private static final ScaXmlNamespace fabric3_0_5_1 = new ScaXmlNamespace("http://fabric3.org/xmlns/sca/tutorials/0.5.1", fabric3);
    private static final ScaXmlNamespace pFrascatiNs = new ScaXmlNamespace("http://frascati.ow2.org", pFrascati);
    private static final ScaXmlNamespace tuscanyNs = new ScaXmlNamespace("http://tuscany.apache.org/xmlns/sca/1.0", tuscany);

    public static List<ScaXmlPlatform> getDefaultPreferences() {
        DefaultPreferences.fabric3.namespaces.add(fabric3_0_5_1);
        DefaultPreferences.addFabric3DefaultBindings();
        DefaultPreferences.pFrascati.namespaces.add(pFrascatiNs);
        DefaultPreferences.addPetalsFrascatiDefaultBindings();
        DefaultPreferences.addPetalsFrascatiDefaultImplementations();
        DefaultPreferences.tuscany.namespaces.add(tuscanyNs);
        DefaultPreferences.addTuscanyDefaultBindings();
        DefaultPreferences.addTuscanyDefaultImplementations();
        DefaultPreferences.addTuscanyDefaultInterfaces();
        ArrayList<ScaXmlPlatform> platforms = new ArrayList<ScaXmlPlatform>();
        platforms.add(fabric3);
        platforms.add(pFrascati);
        platforms.add(tuscany);
        return platforms;
    }

    private static void addPetalsFrascatiDefaultBindings() {
        ScaXmlElement jbiElement = new ScaXmlElement("binding.jbi", pFrascati);
        new ScaXmlAttribute("interfaceName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("interfaceNamespace", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("serviceName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("serviceNamespace", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("endpointName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("operationName", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("operationNamespace", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("wsdl", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("timeout", jbiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(jbiElement);
        DefaultPreferences.pFrascati.bindings.addAll(elements);
        DefaultPreferences.pFrascati.nsToBindings.put(pFrascatiNs, elements);
    }

    private static void addPetalsFrascatiDefaultImplementations() {
        ScaXmlElement fractalElement = new ScaXmlElement("binding.fractal", pFrascati);
        new ScaXmlAttribute("definition", fractalElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(fractalElement);
        DefaultPreferences.pFrascati.implementations.addAll(elements);
        DefaultPreferences.pFrascati.nsToImplementations.put(pFrascatiNs, elements);
    }

    private static void addFabric3DefaultBindings() {
        ScaXmlElement burlapElement = new ScaXmlElement("binding.burlap", fabric3);
        new ScaXmlAttribute("uri", burlapElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement hessianElement = new ScaXmlElement("binding.hessian", fabric3);
        new ScaXmlAttribute("uri", hessianElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(burlapElement);
        elements.add(hessianElement);
        DefaultPreferences.fabric3.bindings.addAll(elements);
        DefaultPreferences.fabric3.nsToBindings.put(fabric3_0_5_1, elements);
    }

    private static void addTuscanyDefaultBindings() {
        String[] rmiAttributes;
        ScaXmlElement ajaxElement = new ScaXmlElement("binding.ajax", tuscany);
        ScaXmlElement dwrElement = new ScaXmlElement("binding.dwr", tuscany);
        ScaXmlElement httpElement = new ScaXmlElement("binding.http", tuscany);
        ScaXmlElement jsonRpcElement = new ScaXmlElement("binding.jsonrpc", tuscany);
        ScaXmlElement atomElement = new ScaXmlElement("binding.atom", tuscany);
        new ScaXmlAttribute("title", atomElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement ejbElement = new ScaXmlElement("binding.ejb", tuscany);
        new ScaXmlAttribute("uri", ejbElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement jmsElement = new ScaXmlElement("binding.jms", tuscany);
        new ScaXmlAttribute("uri", jmsElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement notificationElement = new ScaXmlElement("binding.notification", tuscany);
        new ScaXmlAttribute("ntm", notificationElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("notificationType", notificationElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement rmiElement = new ScaXmlElement("binding.rmi", tuscany);
        String[] stringArray = rmiAttributes = new String[]{"host", "port", "serviceName"};
        int n = rmiAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String rmiAttribute = stringArray[n2];
            new ScaXmlAttribute(rmiAttribute, rmiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
            ++n2;
        }
        ScaXmlElement rssElement = new ScaXmlElement("binding.rss", tuscany);
        new ScaXmlAttribute("title", rssElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(ajaxElement);
        elements.add(dwrElement);
        elements.add(httpElement);
        elements.add(jsonRpcElement);
        elements.add(atomElement);
        elements.add(ejbElement);
        elements.add(jmsElement);
        elements.add(notificationElement);
        elements.add(rmiElement);
        elements.add(rssElement);
        DefaultPreferences.tuscany.bindings.addAll(elements);
        DefaultPreferences.tuscany.nsToBindings.put(tuscanyNs, elements);
    }

    private static void addTuscanyDefaultImplementations() {
        ScaXmlElement bpelElement = new ScaXmlElement("implementation.bpel", tuscany);
        new ScaXmlAttribute("process", bpelElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement dasElement = new ScaXmlElement("implementation.das", tuscany);
        new ScaXmlAttribute("config", dasElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("dataAccessType", dasElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement connectionInfoElement = new ScaXmlElement("ConnectionInfo", dasElement);
        new ScaXmlAttribute("dataSource", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("managedtx", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "true");
        ScaXmlElement connectionPropertiesElement = new ScaXmlElement("ConnectionProperties", connectionInfoElement);
        new ScaXmlAttribute("driverClass", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("databaseURL", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("username", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("password", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("loginTimeout", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "0");
        ScaXmlElement dataElement = new ScaXmlElement("implementation.data", tuscany);
        connectionInfoElement = new ScaXmlElement("ConnectionInfo", dataElement);
        new ScaXmlAttribute("dataSource", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("managedtx", connectionInfoElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "true");
        connectionPropertiesElement = new ScaXmlElement("ConnectionProperties", connectionInfoElement);
        new ScaXmlAttribute("driverClass", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("databaseURL", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("username", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("password", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "");
        new ScaXmlAttribute("loginTimeout", connectionPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional, "", "0");
        ScaXmlElement nodeElement = new ScaXmlElement("implementation.node", tuscany);
        new ScaXmlAttribute("uri", nodeElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("composite", nodeElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement notificationElement = new ScaXmlElement("implementation.notification", tuscany);
        new ScaXmlAttribute("name", notificationElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement osgiElement = new ScaXmlElement("implementation.osgi", tuscany);
        new ScaXmlAttribute("bundleSymbolicName", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        new ScaXmlAttribute("bundleVersion", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("classes", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("imports", osgiElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement osgiPropertiesElement = new ScaXmlElement("properties", osgiElement);
        new ScaXmlAttribute("service", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("reference", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("serviceCallback", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("referenceCallback", osgiPropertiesElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement resourceElement = new ScaXmlElement("implementation.resource", tuscany);
        new ScaXmlAttribute("location", resourceElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement scriptElement = new ScaXmlElement("implementation.script", tuscany);
        new ScaXmlAttribute("script", scriptElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        new ScaXmlAttribute("language", scriptElement, ScaXmlAttribute.ScaXmlAttributeProperty.optional);
        ScaXmlElement xqueryElement = new ScaXmlElement("implementation.xquery", tuscany);
        new ScaXmlAttribute("location", xqueryElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement widgetElement = new ScaXmlElement("implementation.widget", tuscany);
        new ScaXmlAttribute("location", widgetElement, ScaXmlAttribute.ScaXmlAttributeProperty.required);
        ScaXmlElement springElement = new ScaXmlElement("implementation.spring", tuscany);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(bpelElement);
        elements.add(dasElement);
        elements.add(dataElement);
        elements.add(nodeElement);
        elements.add(notificationElement);
        elements.add(osgiElement);
        elements.add(resourceElement);
        elements.add(scriptElement);
        elements.add(xqueryElement);
        elements.add(widgetElement);
        elements.add(springElement);
        DefaultPreferences.tuscany.implementations.addAll(elements);
        DefaultPreferences.tuscany.nsToImplementations.put(tuscanyNs, elements);
    }

    private static void addTuscanyDefaultInterfaces() {
        ScaXmlElement cppElement = new ScaXmlElement("interface.cpp", tuscany);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        elements.add(cppElement);
        DefaultPreferences.tuscany.interfaces.addAll(elements);
        DefaultPreferences.tuscany.nsToInterfaces.put(tuscanyNs, elements);
    }
}

