/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.sca.common.jdt.utils.Base64;
import org.eclipse.stp.sca.xmleditor.ScaXmlEditorPlugin;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaXmlPreferenceUtils {
    public static final String STP_SCA_XML_EDITOR_PREFS = "org.eclipse.stp.sca.xmleditor.preferences";

    public static List<ScaXmlPlatform> getPlatformsFromPS() {
        try {
            IPreferenceStore ps = ScaXmlEditorPlugin.getDefault().getPreferenceStore();
            String prefs = ps.getString(STP_SCA_XML_EDITOR_PREFS);
            ByteArrayInputStream iStream = new ByteArrayInputStream(Base64.decode((byte[])prefs.getBytes()));
            ObjectInputStream o = new ObjectInputStream(iStream);
            List platforms = (List)o.readObject();
            return platforms;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static void savePlatformsToPS(List<ScaXmlPlatform> platforms) {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(oStream);
            o.writeObject(platforms);
            o.close();
            IPreferenceStore ps = ScaXmlEditorPlugin.getDefault().getPreferenceStore();
            byte[] bytes = Base64.encode((byte[])oStream.toByteArray());
            String prefs = new String(bytes);
            ps.setValue(STP_SCA_XML_EDITOR_PREFS, prefs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<ScaXmlElement> getAllBindings(Collection<ScaXmlPlatform> platforms) {
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        for (ScaXmlPlatform platform : platforms) {
            elements.addAll(platform.bindings);
        }
        return elements;
    }

    public static List<ScaXmlElement> getAllBindings() {
        return ScaXmlPreferenceUtils.getAllBindings(ScaXmlPreferenceUtils.getPlatformsFromPS());
    }

    public static List<ScaXmlElement> getAllImplementations(Collection<ScaXmlPlatform> platforms) {
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        for (ScaXmlPlatform platform : platforms) {
            elements.addAll(platform.implementations);
        }
        return elements;
    }

    public static List<ScaXmlElement> getAllImplementations() {
        return ScaXmlPreferenceUtils.getAllImplementations(ScaXmlPreferenceUtils.getPlatformsFromPS());
    }

    public static List<ScaXmlElement> getAllInterfaces(Collection<ScaXmlPlatform> platforms) {
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        for (ScaXmlPlatform platform : platforms) {
            elements.addAll(platform.interfaces);
        }
        return elements;
    }

    public static List<ScaXmlElement> getAllInterfaces() {
        return ScaXmlPreferenceUtils.getAllInterfaces(ScaXmlPreferenceUtils.getPlatformsFromPS());
    }

    public static List<ScaXmlElement> getInterfaces(String ... namespaces) {
        return ScaXmlPreferenceUtils.getAllInterfaces(ScaXmlPreferenceUtils.getPlatforms(namespaces));
    }

    public static List<ScaXmlElement> getImplementations(String ... namespaces) {
        return ScaXmlPreferenceUtils.getAllImplementations(ScaXmlPreferenceUtils.getPlatforms(namespaces));
    }

    public static List<ScaXmlElement> getBindings(String ... namespaces) {
        return ScaXmlPreferenceUtils.getAllBindings(ScaXmlPreferenceUtils.getPlatforms(namespaces));
    }

    public static Set<ScaXmlPlatform> getPlatforms(String ... namespaces) {
        HashSet<ScaXmlPlatform> platforms = new HashSet<ScaXmlPlatform>();
        for (ScaXmlPlatform platform : ScaXmlPreferenceUtils.getPlatformsFromPS()) {
            String[] stringArray = namespaces;
            int n = namespaces.length;
            int n2 = 0;
            while (n2 < n) {
                String namespace = stringArray[n2];
                if (platform.namespaces.contains(namespace)) {
                    platforms.add(platform);
                }
                ++n2;
            }
        }
        return platforms;
    }

    public static Set<ScaXmlNamespace> getAllNamespaces() {
        HashSet<ScaXmlNamespace> namespaces = new HashSet<ScaXmlNamespace>();
        for (ScaXmlPlatform platform : ScaXmlPreferenceUtils.getPlatformsFromPS()) {
            namespaces.addAll(platform.namespaces);
        }
        return namespaces;
    }
}

