/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.viewers;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;

public class ScaXmlViewerFilter
extends ViewerFilter {
    private String namespaceFilter;
    private ScaXmlPlatform.ScaXmlElementType elementType;

    public ScaXmlViewerFilter(String ScaXmlViewerFilter2, ScaXmlPlatform.ScaXmlElementType elementType) {
        this.namespaceFilter = this.namespaceFilter == null ? "" : this.namespaceFilter;
        this.elementType = elementType;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ScaXmlPlatform) {
            ScaXmlPlatform platform = (ScaXmlPlatform)element;
            if (this.namespaceFilter.length() == 0 && platform.namespaces.size() == 0) {
                return true;
            }
            for (ScaXmlNamespace ns : platform.namespaces) {
                if (!ns.getName().startsWith(this.namespaceFilter)) continue;
                return true;
            }
        } else if (element instanceof ScaXmlElement) {
            ScaXmlElement elt = (ScaXmlElement)element;
            if (elt.getPlatform() == null) {
                return true;
            }
            ScaXmlPlatform platform = elt.getPlatform();
            Map<ScaXmlNamespace, List<ScaXmlElement>> elements = this.elementType == ScaXmlPlatform.ScaXmlElementType.bindings ? platform.nsToBindings : (this.elementType == ScaXmlPlatform.ScaXmlElementType.implementations ? platform.nsToImplementations : platform.nsToInterfaces);
            for (Map.Entry<ScaXmlNamespace, List<ScaXmlElement>> entry : elements.entrySet()) {
                if (!entry.getKey().getName().startsWith(this.namespaceFilter) || !entry.getValue().contains(element)) continue;
                return true;
            }
        } else if (element instanceof ScaXmlAttribute) {
            return true;
        }
        return false;
    }

    public String getNamespaceFilter() {
        return this.namespaceFilter;
    }

    public void setNamespaceFilter(String namespaceFilter) {
        this.namespaceFilter = namespaceFilter == null ? "" : namespaceFilter;
    }
}

