/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceExplorer {
    public static List<IFile> getFiles(IProject project) {
        return ResourceExplorer.getFiles(project, "*");
    }

    public static List<IFile> getFiles(IProject project, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(ResourceExplorer.getFiles(subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<IFile> getFiles(IFolder folder) {
        return ResourceExplorer.getFiles(folder, "*");
    }

    public static List<IFile> getFiles(IFolder folder, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = folder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(ResourceExplorer.getFiles(subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IFile getIFileFromEditor() {
        try {
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IFile editedFile = ((FileEditorInput)editorPart.getEditorInput()).getFile();
            return editedFile;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

