/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.utils.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.stp.sca.xmleditor.utils.filters.JavaProjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkippedResources {
    public static Set<IFolder> getResourcesToSkip(IProject project) {
        IJavaProject javaProject = JavaProjectUtils.getJavaProject(project);
        if (javaProject == null) {
            return Collections.emptySet();
        }
        return JavaProjectUtils.getBinaryFolders(javaProject);
    }

    public static Set<IFolder> getResourcesToSkip(IFolder folder) {
        Set<IFolder> result = SkippedResources.getResourcesToSkip(folder.getProject());
        IPath folderPath = folder.getProjectRelativePath();
        for (IFolder projectFolder : result) {
            IPath projectFolderPath = projectFolder.getProjectRelativePath();
            if (folderPath.isPrefixOf(projectFolderPath)) continue;
            result.remove(projectFolder);
        }
        return result;
    }

    public static List<IFile> filterAllowedFiles(List<IFile> filesToFilter) {
        if (filesToFilter.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IFile> result = new ArrayList<IFile>();
        Set<IFolder> foldersToSkip = SkippedResources.getResourcesToSkip(filesToFilter.get(0).getProject());
        for (IFile file : filesToFilter) {
            IPath filePath = file.getProjectRelativePath();
            boolean fileIsInFolder = false;
            for (IFolder projectFolder : foldersToSkip) {
                IPath folderPath = projectFolder.getProjectRelativePath();
                if (!folderPath.isPrefixOf(filePath)) continue;
                fileIsInFolder = true;
                break;
            }
            if (fileIsInFolder) continue;
            result.add(file);
        }
        return result;
    }
}

