/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.editor;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.policy.common.editors.IPolicyDetailEditorInput;
import org.eclipse.stp.ui.xef.editor.Setting;
import org.eclipse.stp.ui.xef.editor.XMLEditPage;
import org.eclipse.stp.ui.xef.editor.XMLProviderEditorInput;
import org.eclipse.stp.ui.xef.editor.XefEditPage;
import org.eclipse.stp.ui.xef.policy.editor.PolicyDetailEditorInputWrapper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

public class XefEditor
extends FormEditor {
    XefEditPage policyEditPage;
    XMLEditPage xmlEditPage;
    XMLProviderEditorInput xmlProvEditorInput;
    public static final String OPEN_ADD_DIALOG = "OPEN_ADD_DIALOG";
    public static final String SELECT_ELEMENT = "SELECT_ELEMENT";
    IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (XefEditor.OPEN_ADD_DIALOG.equals(event.getProperty())) {
                XefEditor.this.policyEditPage.block.addButtonListener.widgetSelected(null);
            } else if (XefEditor.SELECT_ELEMENT.equals(event.getProperty())) {
                String value = (String)event.getNewValue();
                int index = Integer.valueOf(value);
                StructuredSelection selection = new StructuredSelection(XefEditor.this.policyEditPage.block.viewer.getTree().getItem(index).getData());
                XefEditor.this.policyEditPage.block.viewer.setSelection((ISelection)selection);
            }
        }
    };

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, (IEditorInput)XefEditor.ensureXMLProviderEditorInput(input));
        this.xmlProvEditorInput = (XMLProviderEditorInput)this.getEditorInput();
        this.setPartName(this.xmlProvEditorInput.getSetting(Setting.TITLE));
        this.addPartPropertyListener(this.propertyChangeListener);
    }

    private static XMLProviderEditorInput ensureXMLProviderEditorInput(IEditorInput input) {
        if (input instanceof XMLProviderEditorInput) {
            return (XMLProviderEditorInput)input;
        }
        if (input instanceof IPolicyDetailEditorInput) {
            try {
                return new PolicyDetailEditorInputWrapper((IPolicyDetailEditorInput)input);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Editor input should either implement " + IPolicyDetailEditorInput.class.getName() + " or extend " + XMLProviderEditorInput.class.getName() + " but was: " + input.getClass().getName());
    }

    protected void addPages() {
        try {
            this.policyEditPage = new XefEditPage(this, "policy", this.xmlProvEditorInput.getSetting(Setting.TAB_LABEL));
            this.addPage(this.policyEditPage);
            this.xmlEditPage = new XMLEditPage(this, "xml", "XML");
            this.addPage((IEditorPart)this.xmlEditPage, this.getEditorInput());
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    void fireSaveNeeded(IEditorInput input, boolean notify) {
        if (notify) {
            this.editorDirtyStateChanged();
        }
        this.isDirty();
    }

    void fireSaveNeeded() {
        this.editorDirtyStateChanged();
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.synchronizeModelAndText()) {
            return;
        }
        this.xmlEditPage.doSave(monitor);
        try {
            this.xmlProvEditorInput.propagate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.policyEditPage.clearDirty();
        this.firePropertyChange(1);
    }

    private boolean synchronizeModelAndText() {
        if (this.getActivePageInstance() == this.policyEditPage && this.isDirty()) {
            if (!this.policyEditPage.block.validate()) {
                return false;
            }
            this.policyEditPage.getManagedForm().commit(true);
            this.xmlEditPage.syncFromModel();
        }
        return true;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        this.removePartPropertyListener(this.propertyChangeListener);
        super.dispose();
    }
}

